// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> AzureKB web result. </summary>
    public partial class KBWebResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KBWebResult"/>. </summary>
        internal KBWebResult()
        {
            SearchResults = new ChangeTrackingList<KBSearchResult>();
        }

        /// <summary> Initializes a new instance of <see cref="KBWebResult"/>. </summary>
        /// <param name="replacementKey"> Place holder used in HTML Content replace control with the content. </param>
        /// <param name="searchResults"> AzureKB search results. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KBWebResult(string replacementKey, IReadOnlyList<KBSearchResult> searchResults, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ReplacementKey = replacementKey;
            SearchResults = searchResults;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Place holder used in HTML Content replace control with the content. </summary>
        public string ReplacementKey { get; }
        /// <summary> AzureKB search results. </summary>
        public IReadOnlyList<KBSearchResult> SearchResults { get; }
    }
}
