// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Result type of the search result. </summary>
    public readonly partial struct KBSearchResultType : IEquatable<KBSearchResultType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="KBSearchResultType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public KBSearchResultType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CommunityValue = "Community";
        private const string DocumentationValue = "Documentation";

        /// <summary> Community. </summary>
        public static KBSearchResultType Community { get; } = new KBSearchResultType(CommunityValue);
        /// <summary> Documentation. </summary>
        public static KBSearchResultType Documentation { get; } = new KBSearchResultType(DocumentationValue);
        /// <summary> Determines if two <see cref="KBSearchResultType"/> values are the same. </summary>
        public static bool operator ==(KBSearchResultType left, KBSearchResultType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="KBSearchResultType"/> values are not the same. </summary>
        public static bool operator !=(KBSearchResultType left, KBSearchResultType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="KBSearchResultType"/>. </summary>
        public static implicit operator KBSearchResultType(string value) => new KBSearchResultType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is KBSearchResultType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(KBSearchResultType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
