// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Details of an AzureKB search result. </summary>
    public partial class KBSearchResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="KBSearchResult"/>. </summary>
        internal KBSearchResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="KBSearchResult"/>. </summary>
        /// <param name="solutionId"> Unique id of the result. </param>
        /// <param name="content"> Content of the search result. </param>
        /// <param name="title"> Title of the search result. </param>
        /// <param name="confidence"> Confidence of the search result. </param>
        /// <param name="source"> Source of the search result. </param>
        /// <param name="resultType"> Result type of the search result. </param>
        /// <param name="rank"> rank of the search result. </param>
        /// <param name="link"> Link to the document. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal KBSearchResult(string solutionId, string content, string title, SelfHelpConfidence? confidence, string source, KBSearchResultType? resultType, int? rank, string link, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SolutionId = solutionId;
            Content = content;
            Title = title;
            Confidence = confidence;
            Source = source;
            ResultType = resultType;
            Rank = rank;
            Link = link;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Unique id of the result. </summary>
        public string SolutionId { get; }
        /// <summary> Content of the search result. </summary>
        public string Content { get; }
        /// <summary> Title of the search result. </summary>
        public string Title { get; }
        /// <summary> Confidence of the search result. </summary>
        public SelfHelpConfidence? Confidence { get; }
        /// <summary> Source of the search result. </summary>
        public string Source { get; }
        /// <summary> Result type of the search result. </summary>
        public KBSearchResultType? ResultType { get; }
        /// <summary> rank of the search result. </summary>
        public int? Rank { get; }
        /// <summary> Link to the document. </summary>
        public string Link { get; }
    }
}
