// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Allowed values are Sum, Avg, Count, Min, Max. Default is Sum. </summary>
    public readonly partial struct ChartAggregationType : IEquatable<ChartAggregationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ChartAggregationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ChartAggregationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SumValue = "Sum";
        private const string AvgValue = "Avg";
        private const string CountValue = "Count";
        private const string MinValue = "Min";
        private const string MaxValue = "Max";

        /// <summary> Sum. </summary>
        public static ChartAggregationType Sum { get; } = new ChartAggregationType(SumValue);
        /// <summary> Avg. </summary>
        public static ChartAggregationType Avg { get; } = new ChartAggregationType(AvgValue);
        /// <summary> Count. </summary>
        public static ChartAggregationType Count { get; } = new ChartAggregationType(CountValue);
        /// <summary> Min. </summary>
        public static ChartAggregationType Min { get; } = new ChartAggregationType(MinValue);
        /// <summary> Max. </summary>
        public static ChartAggregationType Max { get; } = new ChartAggregationType(MaxValue);
        /// <summary> Determines if two <see cref="ChartAggregationType"/> values are the same. </summary>
        public static bool operator ==(ChartAggregationType left, ChartAggregationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ChartAggregationType"/> values are not the same. </summary>
        public static bool operator !=(ChartAggregationType left, ChartAggregationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ChartAggregationType"/>. </summary>
        public static implicit operator ChartAggregationType(string value) => new ChartAggregationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ChartAggregationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ChartAggregationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
