// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SelfHelp.Models
{
    /// <summary> Type of Result. </summary>
    public readonly partial struct AutomatedCheckResultType : IEquatable<AutomatedCheckResultType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutomatedCheckResultType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutomatedCheckResultType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SuccessValue = "Success";
        private const string WarningValue = "Warning";
        private const string ErrorValue = "Error";
        private const string InformationValue = "Information";

        /// <summary> Success. </summary>
        public static AutomatedCheckResultType Success { get; } = new AutomatedCheckResultType(SuccessValue);
        /// <summary> Warning. </summary>
        public static AutomatedCheckResultType Warning { get; } = new AutomatedCheckResultType(WarningValue);
        /// <summary> Error. </summary>
        public static AutomatedCheckResultType Error { get; } = new AutomatedCheckResultType(ErrorValue);
        /// <summary> Information. </summary>
        public static AutomatedCheckResultType Information { get; } = new AutomatedCheckResultType(InformationValue);
        /// <summary> Determines if two <see cref="AutomatedCheckResultType"/> values are the same. </summary>
        public static bool operator ==(AutomatedCheckResultType left, AutomatedCheckResultType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutomatedCheckResultType"/> values are not the same. </summary>
        public static bool operator !=(AutomatedCheckResultType left, AutomatedCheckResultType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutomatedCheckResultType"/>. </summary>
        public static implicit operator AutomatedCheckResultType(string value) => new AutomatedCheckResultType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutomatedCheckResultType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutomatedCheckResultType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
