// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SelfHelp
{
    internal class SelfHelpSolutionOperationSource : IOperationSource<SelfHelpSolutionResource>
    {
        private readonly ArmClient _client;

        internal SelfHelpSolutionOperationSource(ArmClient client)
        {
            _client = client;
        }

        SelfHelpSolutionResource IOperationSource<SelfHelpSolutionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SelfHelpSolutionData.DeserializeSelfHelpSolutionData(document.RootElement);
            return new SelfHelpSolutionResource(_client, data);
        }

        async ValueTask<SelfHelpSolutionResource> IOperationSource<SelfHelpSolutionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SelfHelpSolutionData.DeserializeSelfHelpSolutionData(document.RootElement);
            return new SelfHelpSolutionResource(_client, data);
        }
    }
}
