// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.SelfHelp.Samples
{
    public partial class Sample_SelfHelpSimplifiedSolutionCollection
    {
        // Solution_Create
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_SolutionCreate()
        {
            // Generated from example definition: specification/help/resource-manager/Microsoft.Help/preview/2024-03-01-preview/examples/SimplifiedSolutions_Create.json
            // this example is just showing the usage of "SimplifiedSolutions_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SelfHelpSimplifiedSolutionResource
            string scope = "subscriptions/mySubscription/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-rp";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            SelfHelpSimplifiedSolutionCollection collection = client.GetSelfHelpSimplifiedSolutions(scopeId);

            // invoke the operation
            string simplifiedSolutionsResourceName = "simplifiedSolutionsResourceName1";
            SelfHelpSimplifiedSolutionData data = new SelfHelpSimplifiedSolutionData()
            {
                SolutionId = "sampleSolutionId",
                Parameters =
{
["resourceUri"] = "subscriptions/mySubscription/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-rp",
},
            };
            ArmOperation<SelfHelpSimplifiedSolutionResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, simplifiedSolutionsResourceName, data);
            SelfHelpSimplifiedSolutionResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SelfHelpSimplifiedSolutionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Solution_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SolutionGet()
        {
            // Generated from example definition: specification/help/resource-manager/Microsoft.Help/preview/2024-03-01-preview/examples/SimplifiedSolutions_Get.json
            // this example is just showing the usage of "SimplifiedSolutions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SelfHelpSimplifiedSolutionResource
            string scope = "subscriptions/mySubscription/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-rp";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            SelfHelpSimplifiedSolutionCollection collection = client.GetSelfHelpSimplifiedSolutions(scopeId);

            // invoke the operation
            string simplifiedSolutionsResourceName = "simplifiedSolutionsResourceName1";
            SelfHelpSimplifiedSolutionResource result = await collection.GetAsync(simplifiedSolutionsResourceName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SelfHelpSimplifiedSolutionData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Solution_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_SolutionGet()
        {
            // Generated from example definition: specification/help/resource-manager/Microsoft.Help/preview/2024-03-01-preview/examples/SimplifiedSolutions_Get.json
            // this example is just showing the usage of "SimplifiedSolutions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SelfHelpSimplifiedSolutionResource
            string scope = "subscriptions/mySubscription/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-rp";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            SelfHelpSimplifiedSolutionCollection collection = client.GetSelfHelpSimplifiedSolutions(scopeId);

            // invoke the operation
            string simplifiedSolutionsResourceName = "simplifiedSolutionsResourceName1";
            bool result = await collection.ExistsAsync(simplifiedSolutionsResourceName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Solution_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_SolutionGet()
        {
            // Generated from example definition: specification/help/resource-manager/Microsoft.Help/preview/2024-03-01-preview/examples/SimplifiedSolutions_Get.json
            // this example is just showing the usage of "SimplifiedSolutions_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ArmResource created on azure
            // for more information of creating ArmResource, please refer to the document of ArmResource

            // get the collection of this SelfHelpSimplifiedSolutionResource
            string scope = "subscriptions/mySubscription/resourcegroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-rp";
            ResourceIdentifier scopeId = new ResourceIdentifier(string.Format("/{0}", scope));
            SelfHelpSimplifiedSolutionCollection collection = client.GetSelfHelpSimplifiedSolutions(scopeId);

            // invoke the operation
            string simplifiedSolutionsResourceName = "simplifiedSolutionsResourceName1";
            NullableResponse<SelfHelpSimplifiedSolutionResource> response = await collection.GetIfExistsAsync(simplifiedSolutionsResourceName);
            SelfHelpSimplifiedSolutionResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SelfHelpSimplifiedSolutionData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }
    }
}
