// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.SelfHelp.Samples
{
    public partial class Sample_SelfHelpDiagnosticResource
    {
        // Creates a Diagnostic for a KeyVault resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreatesADiagnosticForAKeyVaultResource()
        {
            // Generated from example definition: specification/help/resource-manager/Microsoft.Help/preview/2024-03-01-preview/examples/CreateDiagnosticForKeyVaultResource.json
            // this example is just showing the usage of "Diagnostics_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SelfHelpDiagnosticResource created on azure
            // for more information of creating SelfHelpDiagnosticResource, please refer to the document of SelfHelpDiagnosticResource
            string scope = "subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourceGroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read";
            string diagnosticsResourceName = "VMNotWorkingInsight";
            ResourceIdentifier selfHelpDiagnosticResourceId = SelfHelpDiagnosticResource.CreateResourceIdentifier(scope, diagnosticsResourceName);
            SelfHelpDiagnosticResource selfHelpDiagnostic = client.GetSelfHelpDiagnosticResource(selfHelpDiagnosticResourceId);

            // invoke the operation
            SelfHelpDiagnosticData data = new SelfHelpDiagnosticData();
            ArmOperation<SelfHelpDiagnosticResource> lro = await selfHelpDiagnostic.UpdateAsync(WaitUntil.Completed, data);
            SelfHelpDiagnosticResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SelfHelpDiagnosticData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Gets a Diagnostic for a KeyVault resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsADiagnosticForAKeyVaultResource()
        {
            // Generated from example definition: specification/help/resource-manager/Microsoft.Help/preview/2024-03-01-preview/examples/GetDiagnosticForKeyVaultResource.json
            // this example is just showing the usage of "Diagnostics_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SelfHelpDiagnosticResource created on azure
            // for more information of creating SelfHelpDiagnosticResource, please refer to the document of SelfHelpDiagnosticResource
            string scope = "subscriptions/0d0fcd2e-c4fd-4349-8497-200edb3923c6/resourceGroups/myresourceGroup/providers/Microsoft.KeyVault/vaults/test-keyvault-non-read";
            string diagnosticsResourceName = "VMNotWorkingInsight";
            ResourceIdentifier selfHelpDiagnosticResourceId = SelfHelpDiagnosticResource.CreateResourceIdentifier(scope, diagnosticsResourceName);
            SelfHelpDiagnosticResource selfHelpDiagnostic = client.GetSelfHelpDiagnosticResource(selfHelpDiagnosticResourceId);

            // invoke the operation
            SelfHelpDiagnosticResource result = await selfHelpDiagnostic.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SelfHelpDiagnosticData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
