// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="WorkspaceManagerMemberResource"/> and their operations.
    /// Each <see cref="WorkspaceManagerMemberResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="WorkspaceManagerMemberCollection"/> instance call the GetWorkspaceManagerMembers method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class WorkspaceManagerMemberCollection : ArmCollection, IEnumerable<WorkspaceManagerMemberResource>, IAsyncEnumerable<WorkspaceManagerMemberResource>
    {
        private readonly ClientDiagnostics _workspaceManagerMemberClientDiagnostics;
        private readonly WorkspaceManagerMembersRestOperations _workspaceManagerMemberRestClient;

        /// <summary> Initializes a new instance of the <see cref="WorkspaceManagerMemberCollection"/> class for mocking. </summary>
        protected WorkspaceManagerMemberCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="WorkspaceManagerMemberCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal WorkspaceManagerMemberCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _workspaceManagerMemberClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", WorkspaceManagerMemberResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(WorkspaceManagerMemberResource.ResourceType, out string workspaceManagerMemberApiVersion);
            _workspaceManagerMemberRestClient = new WorkspaceManagerMembersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, workspaceManagerMemberApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a workspace manager member
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers/{workspaceManagerMemberName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerMembers_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerMemberResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceManagerMemberName"> The name of the workspace manager member. </param>
        /// <param name="data"> The workspace manager member object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerMemberName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerMemberName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<WorkspaceManagerMemberResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string workspaceManagerMemberName, WorkspaceManagerMemberData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerMemberName, nameof(workspaceManagerMemberName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _workspaceManagerMemberClientDiagnostics.CreateScope("WorkspaceManagerMemberCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _workspaceManagerMemberRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerMemberName, data, cancellationToken).ConfigureAwait(false);
                var uri = _workspaceManagerMemberRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerMemberName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<WorkspaceManagerMemberResource>(Response.FromValue(new WorkspaceManagerMemberResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a workspace manager member
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers/{workspaceManagerMemberName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerMembers_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerMemberResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceManagerMemberName"> The name of the workspace manager member. </param>
        /// <param name="data"> The workspace manager member object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerMemberName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerMemberName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<WorkspaceManagerMemberResource> CreateOrUpdate(WaitUntil waitUntil, string workspaceManagerMemberName, WorkspaceManagerMemberData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerMemberName, nameof(workspaceManagerMemberName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _workspaceManagerMemberClientDiagnostics.CreateScope("WorkspaceManagerMemberCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _workspaceManagerMemberRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerMemberName, data, cancellationToken);
                var uri = _workspaceManagerMemberRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerMemberName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<WorkspaceManagerMemberResource>(Response.FromValue(new WorkspaceManagerMemberResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a workspace manager member
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers/{workspaceManagerMemberName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerMembers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerMemberResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerMemberName"> The name of the workspace manager member. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerMemberName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerMemberName"/> is null. </exception>
        public virtual async Task<Response<WorkspaceManagerMemberResource>> GetAsync(string workspaceManagerMemberName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerMemberName, nameof(workspaceManagerMemberName));

            using var scope = _workspaceManagerMemberClientDiagnostics.CreateScope("WorkspaceManagerMemberCollection.Get");
            scope.Start();
            try
            {
                var response = await _workspaceManagerMemberRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerMemberName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerMemberResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a workspace manager member
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers/{workspaceManagerMemberName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerMembers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerMemberResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerMemberName"> The name of the workspace manager member. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerMemberName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerMemberName"/> is null. </exception>
        public virtual Response<WorkspaceManagerMemberResource> Get(string workspaceManagerMemberName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerMemberName, nameof(workspaceManagerMemberName));

            using var scope = _workspaceManagerMemberClientDiagnostics.CreateScope("WorkspaceManagerMemberCollection.Get");
            scope.Start();
            try
            {
                var response = _workspaceManagerMemberRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerMemberName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerMemberResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all workspace manager members that exist for the given Sentinel workspace manager
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerMembers_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerMemberResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orderBy"> Sorts the results. Optional. </param>
        /// <param name="top"> Returns only the first n results. Optional. </param>
        /// <param name="skipToken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="WorkspaceManagerMemberResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<WorkspaceManagerMemberResource> GetAllAsync(string orderBy = null, int? top = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _workspaceManagerMemberRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _workspaceManagerMemberRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new WorkspaceManagerMemberResource(Client, WorkspaceManagerMemberData.DeserializeWorkspaceManagerMemberData(e)), _workspaceManagerMemberClientDiagnostics, Pipeline, "WorkspaceManagerMemberCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all workspace manager members that exist for the given Sentinel workspace manager
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerMembers_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerMemberResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orderBy"> Sorts the results. Optional. </param>
        /// <param name="top"> Returns only the first n results. Optional. </param>
        /// <param name="skipToken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="WorkspaceManagerMemberResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<WorkspaceManagerMemberResource> GetAll(string orderBy = null, int? top = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _workspaceManagerMemberRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _workspaceManagerMemberRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new WorkspaceManagerMemberResource(Client, WorkspaceManagerMemberData.DeserializeWorkspaceManagerMemberData(e)), _workspaceManagerMemberClientDiagnostics, Pipeline, "WorkspaceManagerMemberCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers/{workspaceManagerMemberName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerMembers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerMemberResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerMemberName"> The name of the workspace manager member. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerMemberName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerMemberName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string workspaceManagerMemberName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerMemberName, nameof(workspaceManagerMemberName));

            using var scope = _workspaceManagerMemberClientDiagnostics.CreateScope("WorkspaceManagerMemberCollection.Exists");
            scope.Start();
            try
            {
                var response = await _workspaceManagerMemberRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerMemberName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers/{workspaceManagerMemberName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerMembers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerMemberResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerMemberName"> The name of the workspace manager member. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerMemberName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerMemberName"/> is null. </exception>
        public virtual Response<bool> Exists(string workspaceManagerMemberName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerMemberName, nameof(workspaceManagerMemberName));

            using var scope = _workspaceManagerMemberClientDiagnostics.CreateScope("WorkspaceManagerMemberCollection.Exists");
            scope.Start();
            try
            {
                var response = _workspaceManagerMemberRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerMemberName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers/{workspaceManagerMemberName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerMembers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerMemberResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerMemberName"> The name of the workspace manager member. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerMemberName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerMemberName"/> is null. </exception>
        public virtual async Task<NullableResponse<WorkspaceManagerMemberResource>> GetIfExistsAsync(string workspaceManagerMemberName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerMemberName, nameof(workspaceManagerMemberName));

            using var scope = _workspaceManagerMemberClientDiagnostics.CreateScope("WorkspaceManagerMemberCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _workspaceManagerMemberRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerMemberName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<WorkspaceManagerMemberResource>(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerMemberResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerMembers/{workspaceManagerMemberName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerMembers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerMemberResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerMemberName"> The name of the workspace manager member. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerMemberName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerMemberName"/> is null. </exception>
        public virtual NullableResponse<WorkspaceManagerMemberResource> GetIfExists(string workspaceManagerMemberName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerMemberName, nameof(workspaceManagerMemberName));

            using var scope = _workspaceManagerMemberClientDiagnostics.CreateScope("WorkspaceManagerMemberCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _workspaceManagerMemberRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerMemberName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<WorkspaceManagerMemberResource>(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerMemberResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<WorkspaceManagerMemberResource> IEnumerable<WorkspaceManagerMemberResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<WorkspaceManagerMemberResource> IAsyncEnumerable<WorkspaceManagerMemberResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
