// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="WorkspaceManagerGroupResource"/> and their operations.
    /// Each <see cref="WorkspaceManagerGroupResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="WorkspaceManagerGroupCollection"/> instance call the GetWorkspaceManagerGroups method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class WorkspaceManagerGroupCollection : ArmCollection, IEnumerable<WorkspaceManagerGroupResource>, IAsyncEnumerable<WorkspaceManagerGroupResource>
    {
        private readonly ClientDiagnostics _workspaceManagerGroupClientDiagnostics;
        private readonly WorkspaceManagerGroupsRestOperations _workspaceManagerGroupRestClient;

        /// <summary> Initializes a new instance of the <see cref="WorkspaceManagerGroupCollection"/> class for mocking. </summary>
        protected WorkspaceManagerGroupCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="WorkspaceManagerGroupCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal WorkspaceManagerGroupCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _workspaceManagerGroupClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", WorkspaceManagerGroupResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(WorkspaceManagerGroupResource.ResourceType, out string workspaceManagerGroupApiVersion);
            _workspaceManagerGroupRestClient = new WorkspaceManagerGroupsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, workspaceManagerGroupApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a workspace manager group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups/{workspaceManagerGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerGroups_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceManagerGroupName"> The name of the workspace manager group. </param>
        /// <param name="data"> The workspace manager group object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerGroupName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<WorkspaceManagerGroupResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string workspaceManagerGroupName, WorkspaceManagerGroupData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerGroupName, nameof(workspaceManagerGroupName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _workspaceManagerGroupClientDiagnostics.CreateScope("WorkspaceManagerGroupCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _workspaceManagerGroupRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerGroupName, data, cancellationToken).ConfigureAwait(false);
                var uri = _workspaceManagerGroupRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerGroupName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<WorkspaceManagerGroupResource>(Response.FromValue(new WorkspaceManagerGroupResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a workspace manager group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups/{workspaceManagerGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerGroups_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceManagerGroupName"> The name of the workspace manager group. </param>
        /// <param name="data"> The workspace manager group object. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerGroupName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<WorkspaceManagerGroupResource> CreateOrUpdate(WaitUntil waitUntil, string workspaceManagerGroupName, WorkspaceManagerGroupData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerGroupName, nameof(workspaceManagerGroupName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _workspaceManagerGroupClientDiagnostics.CreateScope("WorkspaceManagerGroupCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _workspaceManagerGroupRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerGroupName, data, cancellationToken);
                var uri = _workspaceManagerGroupRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerGroupName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<WorkspaceManagerGroupResource>(Response.FromValue(new WorkspaceManagerGroupResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a workspace manager group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups/{workspaceManagerGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerGroupName"> The name of the workspace manager group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerGroupName"/> is null. </exception>
        public virtual async Task<Response<WorkspaceManagerGroupResource>> GetAsync(string workspaceManagerGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerGroupName, nameof(workspaceManagerGroupName));

            using var scope = _workspaceManagerGroupClientDiagnostics.CreateScope("WorkspaceManagerGroupCollection.Get");
            scope.Start();
            try
            {
                var response = await _workspaceManagerGroupRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerGroupName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a workspace manager group
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups/{workspaceManagerGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerGroupName"> The name of the workspace manager group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerGroupName"/> is null. </exception>
        public virtual Response<WorkspaceManagerGroupResource> Get(string workspaceManagerGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerGroupName, nameof(workspaceManagerGroupName));

            using var scope = _workspaceManagerGroupClientDiagnostics.CreateScope("WorkspaceManagerGroupCollection.Get");
            scope.Start();
            try
            {
                var response = _workspaceManagerGroupRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerGroupName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all workspace manager groups in the Sentinel workspace manager
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerGroups_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orderBy"> Sorts the results. Optional. </param>
        /// <param name="top"> Returns only the first n results. Optional. </param>
        /// <param name="skipToken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="WorkspaceManagerGroupResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<WorkspaceManagerGroupResource> GetAllAsync(string orderBy = null, int? top = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _workspaceManagerGroupRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _workspaceManagerGroupRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new WorkspaceManagerGroupResource(Client, WorkspaceManagerGroupData.DeserializeWorkspaceManagerGroupData(e)), _workspaceManagerGroupClientDiagnostics, Pipeline, "WorkspaceManagerGroupCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all workspace manager groups in the Sentinel workspace manager
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerGroups_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orderBy"> Sorts the results. Optional. </param>
        /// <param name="top"> Returns only the first n results. Optional. </param>
        /// <param name="skipToken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="WorkspaceManagerGroupResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<WorkspaceManagerGroupResource> GetAll(string orderBy = null, int? top = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _workspaceManagerGroupRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _workspaceManagerGroupRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new WorkspaceManagerGroupResource(Client, WorkspaceManagerGroupData.DeserializeWorkspaceManagerGroupData(e)), _workspaceManagerGroupClientDiagnostics, Pipeline, "WorkspaceManagerGroupCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups/{workspaceManagerGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerGroupName"> The name of the workspace manager group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerGroupName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string workspaceManagerGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerGroupName, nameof(workspaceManagerGroupName));

            using var scope = _workspaceManagerGroupClientDiagnostics.CreateScope("WorkspaceManagerGroupCollection.Exists");
            scope.Start();
            try
            {
                var response = await _workspaceManagerGroupRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerGroupName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups/{workspaceManagerGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerGroupName"> The name of the workspace manager group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerGroupName"/> is null. </exception>
        public virtual Response<bool> Exists(string workspaceManagerGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerGroupName, nameof(workspaceManagerGroupName));

            using var scope = _workspaceManagerGroupClientDiagnostics.CreateScope("WorkspaceManagerGroupCollection.Exists");
            scope.Start();
            try
            {
                var response = _workspaceManagerGroupRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerGroupName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups/{workspaceManagerGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerGroupName"> The name of the workspace manager group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerGroupName"/> is null. </exception>
        public virtual async Task<NullableResponse<WorkspaceManagerGroupResource>> GetIfExistsAsync(string workspaceManagerGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerGroupName, nameof(workspaceManagerGroupName));

            using var scope = _workspaceManagerGroupClientDiagnostics.CreateScope("WorkspaceManagerGroupCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _workspaceManagerGroupRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerGroupName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<WorkspaceManagerGroupResource>(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerGroups/{workspaceManagerGroupName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerGroups_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerGroupResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerGroupName"> The name of the workspace manager group. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerGroupName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerGroupName"/> is null. </exception>
        public virtual NullableResponse<WorkspaceManagerGroupResource> GetIfExists(string workspaceManagerGroupName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerGroupName, nameof(workspaceManagerGroupName));

            using var scope = _workspaceManagerGroupClientDiagnostics.CreateScope("WorkspaceManagerGroupCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _workspaceManagerGroupRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerGroupName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<WorkspaceManagerGroupResource>(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerGroupResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<WorkspaceManagerGroupResource> IEnumerable<WorkspaceManagerGroupResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<WorkspaceManagerGroupResource> IAsyncEnumerable<WorkspaceManagerGroupResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
