// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing the WorkspaceManagerAssignmentJob data model.
    /// The assignment job
    /// </summary>
    public partial class WorkspaceManagerAssignmentJobData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WorkspaceManagerAssignmentJobData"/>. </summary>
        public WorkspaceManagerAssignmentJobData()
        {
            Items = new ChangeTrackingList<JobItem>();
        }

        /// <summary> Initializes a new instance of <see cref="WorkspaceManagerAssignmentJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="endOn"> The time the job completed. </param>
        /// <param name="items"> List of items published by the job. </param>
        /// <param name="provisioningState"> State of the job. </param>
        /// <param name="startOn"> The time the job started. </param>
        /// <param name="errorMessage"> Message to describe error, if an error exists. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WorkspaceManagerAssignmentJobData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? endOn, IList<JobItem> items, TriggeredAnalyticsRuleRunProvisioningState? provisioningState, DateTimeOffset? startOn, string errorMessage, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            EndOn = endOn;
            Items = items;
            ProvisioningState = provisioningState;
            StartOn = startOn;
            ErrorMessage = errorMessage;
            ETag = etag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The time the job completed. </summary>
        [WirePath("properties.endTime")]
        public DateTimeOffset? EndOn { get; }
        /// <summary> List of items published by the job. </summary>
        [WirePath("properties.items")]
        public IList<JobItem> Items { get; }
        /// <summary> State of the job. </summary>
        [WirePath("properties.provisioningState")]
        public TriggeredAnalyticsRuleRunProvisioningState? ProvisioningState { get; }
        /// <summary> The time the job started. </summary>
        [WirePath("properties.startTime")]
        public DateTimeOffset? StartOn { get; }
        /// <summary> Message to describe error, if an error exists. </summary>
        [WirePath("properties.errorMessage")]
        public string ErrorMessage { get; }
        /// <summary> Etag of the azure resource. </summary>
        [WirePath("etag")]
        public ETag? ETag { get; set; }
    }
}
