// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="WorkspaceManagerAssignmentResource"/> and their operations.
    /// Each <see cref="WorkspaceManagerAssignmentResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="WorkspaceManagerAssignmentCollection"/> instance call the GetWorkspaceManagerAssignments method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class WorkspaceManagerAssignmentCollection : ArmCollection, IEnumerable<WorkspaceManagerAssignmentResource>, IAsyncEnumerable<WorkspaceManagerAssignmentResource>
    {
        private readonly ClientDiagnostics _workspaceManagerAssignmentClientDiagnostics;
        private readonly WorkspaceManagerAssignmentsRestOperations _workspaceManagerAssignmentRestClient;

        /// <summary> Initializes a new instance of the <see cref="WorkspaceManagerAssignmentCollection"/> class for mocking. </summary>
        protected WorkspaceManagerAssignmentCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="WorkspaceManagerAssignmentCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal WorkspaceManagerAssignmentCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _workspaceManagerAssignmentClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", WorkspaceManagerAssignmentResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(WorkspaceManagerAssignmentResource.ResourceType, out string workspaceManagerAssignmentApiVersion);
            _workspaceManagerAssignmentRestClient = new WorkspaceManagerAssignmentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, workspaceManagerAssignmentApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a workspace manager assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments/{workspaceManagerAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerAssignments_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceManagerAssignmentName"> The name of the workspace manager assignment. </param>
        /// <param name="data"> The workspace manager assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerAssignmentName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<WorkspaceManagerAssignmentResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string workspaceManagerAssignmentName, WorkspaceManagerAssignmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerAssignmentName, nameof(workspaceManagerAssignmentName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _workspaceManagerAssignmentClientDiagnostics.CreateScope("WorkspaceManagerAssignmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _workspaceManagerAssignmentRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerAssignmentName, data, cancellationToken).ConfigureAwait(false);
                var uri = _workspaceManagerAssignmentRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerAssignmentName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<WorkspaceManagerAssignmentResource>(Response.FromValue(new WorkspaceManagerAssignmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a workspace manager assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments/{workspaceManagerAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerAssignments_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="workspaceManagerAssignmentName"> The name of the workspace manager assignment. </param>
        /// <param name="data"> The workspace manager assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerAssignmentName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<WorkspaceManagerAssignmentResource> CreateOrUpdate(WaitUntil waitUntil, string workspaceManagerAssignmentName, WorkspaceManagerAssignmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerAssignmentName, nameof(workspaceManagerAssignmentName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _workspaceManagerAssignmentClientDiagnostics.CreateScope("WorkspaceManagerAssignmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _workspaceManagerAssignmentRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerAssignmentName, data, cancellationToken);
                var uri = _workspaceManagerAssignmentRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerAssignmentName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<WorkspaceManagerAssignmentResource>(Response.FromValue(new WorkspaceManagerAssignmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a workspace manager assignment
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments/{workspaceManagerAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerAssignmentName"> The name of the workspace manager assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerAssignmentName"/> is null. </exception>
        public virtual async Task<Response<WorkspaceManagerAssignmentResource>> GetAsync(string workspaceManagerAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerAssignmentName, nameof(workspaceManagerAssignmentName));

            using var scope = _workspaceManagerAssignmentClientDiagnostics.CreateScope("WorkspaceManagerAssignmentCollection.Get");
            scope.Start();
            try
            {
                var response = await _workspaceManagerAssignmentRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerAssignmentName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a workspace manager assignment
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments/{workspaceManagerAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerAssignmentName"> The name of the workspace manager assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerAssignmentName"/> is null. </exception>
        public virtual Response<WorkspaceManagerAssignmentResource> Get(string workspaceManagerAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerAssignmentName, nameof(workspaceManagerAssignmentName));

            using var scope = _workspaceManagerAssignmentClientDiagnostics.CreateScope("WorkspaceManagerAssignmentCollection.Get");
            scope.Start();
            try
            {
                var response = _workspaceManagerAssignmentRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerAssignmentName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get all workspace manager assignments for the Sentinel workspace manager.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerAssignments_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orderBy"> Sorts the results. Optional. </param>
        /// <param name="top"> Returns only the first n results. Optional. </param>
        /// <param name="skipToken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="WorkspaceManagerAssignmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<WorkspaceManagerAssignmentResource> GetAllAsync(string orderBy = null, int? top = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _workspaceManagerAssignmentRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _workspaceManagerAssignmentRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new WorkspaceManagerAssignmentResource(Client, WorkspaceManagerAssignmentData.DeserializeWorkspaceManagerAssignmentData(e)), _workspaceManagerAssignmentClientDiagnostics, Pipeline, "WorkspaceManagerAssignmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Get all workspace manager assignments for the Sentinel workspace manager.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerAssignments_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="orderBy"> Sorts the results. Optional. </param>
        /// <param name="top"> Returns only the first n results. Optional. </param>
        /// <param name="skipToken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="WorkspaceManagerAssignmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<WorkspaceManagerAssignmentResource> GetAll(string orderBy = null, int? top = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _workspaceManagerAssignmentRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _workspaceManagerAssignmentRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, orderBy, top, skipToken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new WorkspaceManagerAssignmentResource(Client, WorkspaceManagerAssignmentData.DeserializeWorkspaceManagerAssignmentData(e)), _workspaceManagerAssignmentClientDiagnostics, Pipeline, "WorkspaceManagerAssignmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments/{workspaceManagerAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerAssignmentName"> The name of the workspace manager assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerAssignmentName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string workspaceManagerAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerAssignmentName, nameof(workspaceManagerAssignmentName));

            using var scope = _workspaceManagerAssignmentClientDiagnostics.CreateScope("WorkspaceManagerAssignmentCollection.Exists");
            scope.Start();
            try
            {
                var response = await _workspaceManagerAssignmentRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerAssignmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments/{workspaceManagerAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerAssignmentName"> The name of the workspace manager assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerAssignmentName"/> is null. </exception>
        public virtual Response<bool> Exists(string workspaceManagerAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerAssignmentName, nameof(workspaceManagerAssignmentName));

            using var scope = _workspaceManagerAssignmentClientDiagnostics.CreateScope("WorkspaceManagerAssignmentCollection.Exists");
            scope.Start();
            try
            {
                var response = _workspaceManagerAssignmentRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerAssignmentName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments/{workspaceManagerAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerAssignmentName"> The name of the workspace manager assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerAssignmentName"/> is null. </exception>
        public virtual async Task<NullableResponse<WorkspaceManagerAssignmentResource>> GetIfExistsAsync(string workspaceManagerAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerAssignmentName, nameof(workspaceManagerAssignmentName));

            using var scope = _workspaceManagerAssignmentClientDiagnostics.CreateScope("WorkspaceManagerAssignmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _workspaceManagerAssignmentRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerAssignmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<WorkspaceManagerAssignmentResource>(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/workspaceManagerAssignments/{workspaceManagerAssignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>WorkspaceManagerAssignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="WorkspaceManagerAssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="workspaceManagerAssignmentName"> The name of the workspace manager assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="workspaceManagerAssignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="workspaceManagerAssignmentName"/> is null. </exception>
        public virtual NullableResponse<WorkspaceManagerAssignmentResource> GetIfExists(string workspaceManagerAssignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(workspaceManagerAssignmentName, nameof(workspaceManagerAssignmentName));

            using var scope = _workspaceManagerAssignmentClientDiagnostics.CreateScope("WorkspaceManagerAssignmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _workspaceManagerAssignmentRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, workspaceManagerAssignmentName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<WorkspaceManagerAssignmentResource>(response.GetRawResponse());
                return Response.FromValue(new WorkspaceManagerAssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<WorkspaceManagerAssignmentResource> IEnumerable<WorkspaceManagerAssignmentResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<WorkspaceManagerAssignmentResource> IAsyncEnumerable<WorkspaceManagerAssignmentResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
