// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A Class representing a TriggeredAnalyticsRuleRun along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="TriggeredAnalyticsRuleRunResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetTriggeredAnalyticsRuleRunResource method.
    /// Otherwise you can get one from its parent resource <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/> using the GetTriggeredAnalyticsRuleRun method.
    /// </summary>
    public partial class TriggeredAnalyticsRuleRunResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="TriggeredAnalyticsRuleRunResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="workspaceName"> The workspaceName. </param>
        /// <param name="ruleRunId"> The ruleRunId. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string workspaceName, string ruleRunId)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns/{ruleRunId}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics;
        private readonly TriggeredAnalyticsRuleRunRestOperations _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient;
        private readonly TriggeredAnalyticsRuleRunData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns";

        /// <summary> Initializes a new instance of the <see cref="TriggeredAnalyticsRuleRunResource"/> class for mocking. </summary>
        protected TriggeredAnalyticsRuleRunResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="TriggeredAnalyticsRuleRunResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal TriggeredAnalyticsRuleRunResource(ArmClient client, TriggeredAnalyticsRuleRunData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="TriggeredAnalyticsRuleRunResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal TriggeredAnalyticsRuleRunResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunApiVersion);
            _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient = new TriggeredAnalyticsRuleRunRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual TriggeredAnalyticsRuleRunData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the triggered analytics rule run.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns/{ruleRunId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>triggeredAnalyticsRuleRun_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TriggeredAnalyticsRuleRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<TriggeredAnalyticsRuleRunResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics.CreateScope("TriggeredAnalyticsRuleRunResource.Get");
            scope.Start();
            try
            {
                var response = await _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new TriggeredAnalyticsRuleRunResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the triggered analytics rule run.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns/{ruleRunId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>triggeredAnalyticsRuleRun_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TriggeredAnalyticsRuleRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<TriggeredAnalyticsRuleRunResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics.CreateScope("TriggeredAnalyticsRuleRunResource.Get");
            scope.Start();
            try
            {
                var response = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new TriggeredAnalyticsRuleRunResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
