// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="TriggeredAnalyticsRuleRunResource"/> and their operations.
    /// Each <see cref="TriggeredAnalyticsRuleRunResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="TriggeredAnalyticsRuleRunCollection"/> instance call the GetTriggeredAnalyticsRuleRuns method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class TriggeredAnalyticsRuleRunCollection : ArmCollection, IEnumerable<TriggeredAnalyticsRuleRunResource>, IAsyncEnumerable<TriggeredAnalyticsRuleRunResource>
    {
        private readonly ClientDiagnostics _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics;
        private readonly TriggeredAnalyticsRuleRunRestOperations _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient;
        private readonly ClientDiagnostics _triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsClientDiagnostics;
        private readonly GetTriggeredAnalyticsRuleRunsRestOperations _triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsRestClient;

        /// <summary> Initializes a new instance of the <see cref="TriggeredAnalyticsRuleRunCollection"/> class for mocking. </summary>
        protected TriggeredAnalyticsRuleRunCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="TriggeredAnalyticsRuleRunCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal TriggeredAnalyticsRuleRunCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", TriggeredAnalyticsRuleRunResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(TriggeredAnalyticsRuleRunResource.ResourceType, out string triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunApiVersion);
            _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient = new TriggeredAnalyticsRuleRunRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunApiVersion);
            _triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", TriggeredAnalyticsRuleRunResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(TriggeredAnalyticsRuleRunResource.ResourceType, out string triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsApiVersion);
            _triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsRestClient = new GetTriggeredAnalyticsRuleRunsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets the triggered analytics rule run.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns/{ruleRunId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>triggeredAnalyticsRuleRun_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TriggeredAnalyticsRuleRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleRunId"> the triggered rule id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleRunId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleRunId"/> is null. </exception>
        public virtual async Task<Response<TriggeredAnalyticsRuleRunResource>> GetAsync(string ruleRunId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleRunId, nameof(ruleRunId));

            using var scope = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics.CreateScope("TriggeredAnalyticsRuleRunCollection.Get");
            scope.Start();
            try
            {
                var response = await _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ruleRunId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new TriggeredAnalyticsRuleRunResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the triggered analytics rule run.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns/{ruleRunId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>triggeredAnalyticsRuleRun_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TriggeredAnalyticsRuleRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleRunId"> the triggered rule id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleRunId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleRunId"/> is null. </exception>
        public virtual Response<TriggeredAnalyticsRuleRunResource> Get(string ruleRunId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleRunId, nameof(ruleRunId));

            using var scope = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics.CreateScope("TriggeredAnalyticsRuleRunCollection.Get");
            scope.Start();
            try
            {
                var response = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ruleRunId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new TriggeredAnalyticsRuleRunResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the triggered analytics rule runs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>getTriggeredAnalyticsRuleRuns_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TriggeredAnalyticsRuleRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="TriggeredAnalyticsRuleRunResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<TriggeredAnalyticsRuleRunResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new TriggeredAnalyticsRuleRunResource(Client, TriggeredAnalyticsRuleRunData.DeserializeTriggeredAnalyticsRuleRunData(e)), _triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsClientDiagnostics, Pipeline, "TriggeredAnalyticsRuleRunCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets the triggered analytics rule runs.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>getTriggeredAnalyticsRuleRuns_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TriggeredAnalyticsRuleRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="TriggeredAnalyticsRuleRunResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<TriggeredAnalyticsRuleRunResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new TriggeredAnalyticsRuleRunResource(Client, TriggeredAnalyticsRuleRunData.DeserializeTriggeredAnalyticsRuleRunData(e)), _triggeredAnalyticsRuleRungetTriggeredAnalyticsRuleRunsClientDiagnostics, Pipeline, "TriggeredAnalyticsRuleRunCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns/{ruleRunId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>triggeredAnalyticsRuleRun_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TriggeredAnalyticsRuleRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleRunId"> the triggered rule id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleRunId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleRunId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string ruleRunId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleRunId, nameof(ruleRunId));

            using var scope = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics.CreateScope("TriggeredAnalyticsRuleRunCollection.Exists");
            scope.Start();
            try
            {
                var response = await _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ruleRunId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns/{ruleRunId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>triggeredAnalyticsRuleRun_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TriggeredAnalyticsRuleRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleRunId"> the triggered rule id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleRunId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleRunId"/> is null. </exception>
        public virtual Response<bool> Exists(string ruleRunId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleRunId, nameof(ruleRunId));

            using var scope = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics.CreateScope("TriggeredAnalyticsRuleRunCollection.Exists");
            scope.Start();
            try
            {
                var response = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ruleRunId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns/{ruleRunId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>triggeredAnalyticsRuleRun_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TriggeredAnalyticsRuleRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleRunId"> the triggered rule id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleRunId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleRunId"/> is null. </exception>
        public virtual async Task<NullableResponse<TriggeredAnalyticsRuleRunResource>> GetIfExistsAsync(string ruleRunId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleRunId, nameof(ruleRunId));

            using var scope = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics.CreateScope("TriggeredAnalyticsRuleRunCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ruleRunId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<TriggeredAnalyticsRuleRunResource>(response.GetRawResponse());
                return Response.FromValue(new TriggeredAnalyticsRuleRunResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/triggeredAnalyticsRuleRuns/{ruleRunId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>triggeredAnalyticsRuleRun_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="TriggeredAnalyticsRuleRunResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleRunId"> the triggered rule id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleRunId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleRunId"/> is null. </exception>
        public virtual NullableResponse<TriggeredAnalyticsRuleRunResource> GetIfExists(string ruleRunId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleRunId, nameof(ruleRunId));

            using var scope = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunClientDiagnostics.CreateScope("TriggeredAnalyticsRuleRunCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _triggeredAnalyticsRuleRuntriggeredAnalyticsRuleRunRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, ruleRunId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<TriggeredAnalyticsRuleRunResource>(response.GetRawResponse());
                return Response.FromValue(new TriggeredAnalyticsRuleRunResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<TriggeredAnalyticsRuleRunResource> IEnumerable<TriggeredAnalyticsRuleRunResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<TriggeredAnalyticsRuleRunResource> IAsyncEnumerable<TriggeredAnalyticsRuleRunResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
