// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsTemplateResource"/> and their operations.
    /// Each <see cref="SecurityInsightsTemplateResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="SecurityInsightsTemplateCollection"/> instance call the GetSecurityInsightsTemplates method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class SecurityInsightsTemplateCollection : ArmCollection, IEnumerable<SecurityInsightsTemplateResource>, IAsyncEnumerable<SecurityInsightsTemplateResource>
    {
        private readonly ClientDiagnostics _securityInsightsTemplateContentTemplateClientDiagnostics;
        private readonly ContentTemplateRestOperations _securityInsightsTemplateContentTemplateRestClient;
        private readonly ClientDiagnostics _securityInsightsTemplateContentTemplatesClientDiagnostics;
        private readonly ContentTemplatesRestOperations _securityInsightsTemplateContentTemplatesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsTemplateCollection"/> class for mocking. </summary>
        protected SecurityInsightsTemplateCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsTemplateCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsTemplateCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsTemplateContentTemplateClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsTemplateResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsTemplateResource.ResourceType, out string securityInsightsTemplateContentTemplateApiVersion);
            _securityInsightsTemplateContentTemplateRestClient = new ContentTemplateRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsTemplateContentTemplateApiVersion);
            _securityInsightsTemplateContentTemplatesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsTemplateResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsTemplateResource.ResourceType, out string securityInsightsTemplateContentTemplatesApiVersion);
            _securityInsightsTemplateContentTemplatesRestClient = new ContentTemplatesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsTemplateContentTemplatesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Install a template.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContentTemplate_Install</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="templateId"> template Id. </param>
        /// <param name="data"> Template installation properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SecurityInsightsTemplateResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string templateId, SecurityInsightsTemplateData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsTemplateContentTemplateClientDiagnostics.CreateScope("SecurityInsightsTemplateCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _securityInsightsTemplateContentTemplateRestClient.InstallAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, data, cancellationToken).ConfigureAwait(false);
                var uri = _securityInsightsTemplateContentTemplateRestClient.CreateInstallRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsTemplateResource>(Response.FromValue(new SecurityInsightsTemplateResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Install a template.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContentTemplate_Install</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="templateId"> template Id. </param>
        /// <param name="data"> Template installation properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SecurityInsightsTemplateResource> CreateOrUpdate(WaitUntil waitUntil, string templateId, SecurityInsightsTemplateData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsTemplateContentTemplateClientDiagnostics.CreateScope("SecurityInsightsTemplateCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _securityInsightsTemplateContentTemplateRestClient.Install(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, data, cancellationToken);
                var uri = _securityInsightsTemplateContentTemplateRestClient.CreateInstallRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsTemplateResource>(Response.FromValue(new SecurityInsightsTemplateResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a template byt its identifier.
        /// Expandable properties:
        /// - properties/mainTemplate
        /// - properties/dependantTemplates
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContentTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsTemplateResource>> GetAsync(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsTemplateContentTemplateClientDiagnostics.CreateScope("SecurityInsightsTemplateCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsTemplateContentTemplateRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a template byt its identifier.
        /// Expandable properties:
        /// - properties/mainTemplate
        /// - properties/dependantTemplates
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContentTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual Response<SecurityInsightsTemplateResource> Get(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsTemplateContentTemplateClientDiagnostics.CreateScope("SecurityInsightsTemplateCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsTemplateContentTemplateRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all installed templates.
        /// Expandable properties:
        /// - properties/mainTemplate
        /// - properties/dependantTemplates
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContentTemplates_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsTemplateResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsTemplateResource> GetAllAsync(SecurityInsightsTemplateCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new SecurityInsightsTemplateCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsTemplateContentTemplatesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, options.Filter, options.OrderBy, options.Expand, options.Search, options.Count, options.Top, options.Skip, options.SkipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsTemplateContentTemplatesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, options.Filter, options.OrderBy, options.Expand, options.Search, options.Count, options.Top, options.Skip, options.SkipToken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsTemplateResource(Client, SecurityInsightsTemplateData.DeserializeSecurityInsightsTemplateData(e)), _securityInsightsTemplateContentTemplatesClientDiagnostics, Pipeline, "SecurityInsightsTemplateCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all installed templates.
        /// Expandable properties:
        /// - properties/mainTemplate
        /// - properties/dependantTemplates
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContentTemplates_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsTemplateResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsTemplateResource> GetAll(SecurityInsightsTemplateCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new SecurityInsightsTemplateCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsTemplateContentTemplatesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, options.Filter, options.OrderBy, options.Expand, options.Search, options.Count, options.Top, options.Skip, options.SkipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsTemplateContentTemplatesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, options.Filter, options.OrderBy, options.Expand, options.Search, options.Count, options.Top, options.Skip, options.SkipToken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsTemplateResource(Client, SecurityInsightsTemplateData.DeserializeSecurityInsightsTemplateData(e)), _securityInsightsTemplateContentTemplatesClientDiagnostics, Pipeline, "SecurityInsightsTemplateCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContentTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsTemplateContentTemplateClientDiagnostics.CreateScope("SecurityInsightsTemplateCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsTemplateContentTemplateRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContentTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual Response<bool> Exists(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsTemplateContentTemplateClientDiagnostics.CreateScope("SecurityInsightsTemplateCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsTemplateContentTemplateRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContentTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsTemplateResource>> GetIfExistsAsync(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsTemplateContentTemplateClientDiagnostics.CreateScope("SecurityInsightsTemplateCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsTemplateContentTemplateRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsTemplateResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentTemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ContentTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsTemplateResource> GetIfExists(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsTemplateContentTemplateClientDiagnostics.CreateScope("SecurityInsightsTemplateCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsTemplateContentTemplateRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsTemplateResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsTemplateResource> IEnumerable<SecurityInsightsTemplateResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsTemplateResource> IAsyncEnumerable<SecurityInsightsTemplateResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
