// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsSettingResource"/> and their operations.
    /// Each <see cref="SecurityInsightsSettingResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="SecurityInsightsSettingCollection"/> instance call the GetSecurityInsightsSettings method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class SecurityInsightsSettingCollection : ArmCollection, IEnumerable<SecurityInsightsSettingResource>, IAsyncEnumerable<SecurityInsightsSettingResource>
    {
        private readonly ClientDiagnostics _securityInsightsSettingProductSettingsClientDiagnostics;
        private readonly ProductSettingsRestOperations _securityInsightsSettingProductSettingsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsSettingCollection"/> class for mocking. </summary>
        protected SecurityInsightsSettingCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsSettingCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsSettingCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsSettingProductSettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsSettingResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsSettingResource.ResourceType, out string securityInsightsSettingProductSettingsApiVersion);
            _securityInsightsSettingProductSettingsRestClient = new ProductSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsSettingProductSettingsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Updates setting.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings/{settingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductSettings_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="settingsName"> The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba. </param>
        /// <param name="data"> The setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="settingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="settingsName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SecurityInsightsSettingResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string settingsName, SecurityInsightsSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(settingsName, nameof(settingsName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsSettingProductSettingsClientDiagnostics.CreateScope("SecurityInsightsSettingCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _securityInsightsSettingProductSettingsRestClient.UpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsName, data, cancellationToken).ConfigureAwait(false);
                var uri = _securityInsightsSettingProductSettingsRestClient.CreateUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsSettingResource>(Response.FromValue(new SecurityInsightsSettingResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Updates setting.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings/{settingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductSettings_Update</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="settingsName"> The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba. </param>
        /// <param name="data"> The setting. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="settingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="settingsName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SecurityInsightsSettingResource> CreateOrUpdate(WaitUntil waitUntil, string settingsName, SecurityInsightsSettingData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(settingsName, nameof(settingsName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsSettingProductSettingsClientDiagnostics.CreateScope("SecurityInsightsSettingCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _securityInsightsSettingProductSettingsRestClient.Update(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsName, data, cancellationToken);
                var uri = _securityInsightsSettingProductSettingsRestClient.CreateUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsSettingResource>(Response.FromValue(new SecurityInsightsSettingResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a setting.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings/{settingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsName"> The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="settingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="settingsName"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsSettingResource>> GetAsync(string settingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(settingsName, nameof(settingsName));

            using var scope = _securityInsightsSettingProductSettingsClientDiagnostics.CreateScope("SecurityInsightsSettingCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsSettingProductSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a setting.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings/{settingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsName"> The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="settingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="settingsName"/> is null. </exception>
        public virtual Response<SecurityInsightsSettingResource> Get(string settingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(settingsName, nameof(settingsName));

            using var scope = _securityInsightsSettingProductSettingsClientDiagnostics.CreateScope("SecurityInsightsSettingCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsSettingProductSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List of all the settings
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductSettings_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsSettingResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsSettingResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsSettingProductSettingsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => new SecurityInsightsSettingResource(Client, SecurityInsightsSettingData.DeserializeSecurityInsightsSettingData(e)), _securityInsightsSettingProductSettingsClientDiagnostics, Pipeline, "SecurityInsightsSettingCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// List of all the settings
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductSettings_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsSettingResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsSettingResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsSettingProductSettingsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => new SecurityInsightsSettingResource(Client, SecurityInsightsSettingData.DeserializeSecurityInsightsSettingData(e)), _securityInsightsSettingProductSettingsClientDiagnostics, Pipeline, "SecurityInsightsSettingCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings/{settingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsName"> The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="settingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="settingsName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string settingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(settingsName, nameof(settingsName));

            using var scope = _securityInsightsSettingProductSettingsClientDiagnostics.CreateScope("SecurityInsightsSettingCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsSettingProductSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings/{settingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsName"> The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="settingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="settingsName"/> is null. </exception>
        public virtual Response<bool> Exists(string settingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(settingsName, nameof(settingsName));

            using var scope = _securityInsightsSettingProductSettingsClientDiagnostics.CreateScope("SecurityInsightsSettingCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsSettingProductSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings/{settingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsName"> The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="settingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="settingsName"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsSettingResource>> GetIfExistsAsync(string settingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(settingsName, nameof(settingsName));

            using var scope = _securityInsightsSettingProductSettingsClientDiagnostics.CreateScope("SecurityInsightsSettingCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsSettingProductSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsSettingResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/settings/{settingsName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsSettingResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="settingsName"> The setting name. Supports - Anomalies, EyesOn, EntityAnalytics, Ueba. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="settingsName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="settingsName"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsSettingResource> GetIfExists(string settingsName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(settingsName, nameof(settingsName));

            using var scope = _securityInsightsSettingProductSettingsClientDiagnostics.CreateScope("SecurityInsightsSettingCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsSettingProductSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, settingsName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsSettingResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsSettingResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsSettingResource> IEnumerable<SecurityInsightsSettingResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsSettingResource> IAsyncEnumerable<SecurityInsightsSettingResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
