// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsRecommendationResource"/> and their operations.
    /// Each <see cref="SecurityInsightsRecommendationResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="SecurityInsightsRecommendationCollection"/> instance call the GetSecurityInsightsRecommendations method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class SecurityInsightsRecommendationCollection : ArmCollection, IEnumerable<SecurityInsightsRecommendationResource>, IAsyncEnumerable<SecurityInsightsRecommendationResource>
    {
        private readonly ClientDiagnostics _securityInsightsRecommendationGetClientDiagnostics;
        private readonly GetRestOperations _securityInsightsRecommendationGetRestClient;
        private readonly ClientDiagnostics _securityInsightsRecommendationGetRecommendationsClientDiagnostics;
        private readonly GetRecommendationsRestOperations _securityInsightsRecommendationGetRecommendationsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsRecommendationCollection"/> class for mocking. </summary>
        protected SecurityInsightsRecommendationCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsRecommendationCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsRecommendationCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsRecommendationGetClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsRecommendationResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsRecommendationResource.ResourceType, out string securityInsightsRecommendationGetApiVersion);
            _securityInsightsRecommendationGetRestClient = new GetRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsRecommendationGetApiVersion);
            _securityInsightsRecommendationGetRecommendationsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsRecommendationResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsRecommendationResource.ResourceType, out string securityInsightsRecommendationGetRecommendationsApiVersion);
            _securityInsightsRecommendationGetRecommendationsRestClient = new GetRecommendationsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsRecommendationGetRecommendationsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a recommendation by its id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/recommendations/{recommendationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Get_SingleRecommendation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsRecommendationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="recommendationId"> Recommendation Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SecurityInsightsRecommendationResource>> GetAsync(Guid recommendationId, CancellationToken cancellationToken = default)
        {
            using var scope = _securityInsightsRecommendationGetClientDiagnostics.CreateScope("SecurityInsightsRecommendationCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsRecommendationGetRestClient.SingleRecommendationAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, recommendationId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsRecommendationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a recommendation by its id.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/recommendations/{recommendationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Get_SingleRecommendation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsRecommendationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="recommendationId"> Recommendation Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SecurityInsightsRecommendationResource> Get(Guid recommendationId, CancellationToken cancellationToken = default)
        {
            using var scope = _securityInsightsRecommendationGetClientDiagnostics.CreateScope("SecurityInsightsRecommendationCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsRecommendationGetRestClient.SingleRecommendation(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, recommendationId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsRecommendationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of all recommendations.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/recommendations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GetRecommendations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsRecommendationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsRecommendationResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsRecommendationResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsRecommendationGetRecommendationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => new SecurityInsightsRecommendationResource(Client, SecurityInsightsRecommendationData.DeserializeSecurityInsightsRecommendationData(e)), _securityInsightsRecommendationGetRecommendationsClientDiagnostics, Pipeline, "SecurityInsightsRecommendationCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Gets a list of all recommendations.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/recommendations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>GetRecommendations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsRecommendationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsRecommendationResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsRecommendationResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsRecommendationGetRecommendationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => new SecurityInsightsRecommendationResource(Client, SecurityInsightsRecommendationData.DeserializeSecurityInsightsRecommendationData(e)), _securityInsightsRecommendationGetRecommendationsClientDiagnostics, Pipeline, "SecurityInsightsRecommendationCollection.GetAll", "value", null, cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/recommendations/{recommendationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Get_SingleRecommendation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsRecommendationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="recommendationId"> Recommendation Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(Guid recommendationId, CancellationToken cancellationToken = default)
        {
            using var scope = _securityInsightsRecommendationGetClientDiagnostics.CreateScope("SecurityInsightsRecommendationCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsRecommendationGetRestClient.SingleRecommendationAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, recommendationId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/recommendations/{recommendationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Get_SingleRecommendation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsRecommendationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="recommendationId"> Recommendation Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(Guid recommendationId, CancellationToken cancellationToken = default)
        {
            using var scope = _securityInsightsRecommendationGetClientDiagnostics.CreateScope("SecurityInsightsRecommendationCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsRecommendationGetRestClient.SingleRecommendation(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, recommendationId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/recommendations/{recommendationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Get_SingleRecommendation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsRecommendationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="recommendationId"> Recommendation Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<SecurityInsightsRecommendationResource>> GetIfExistsAsync(Guid recommendationId, CancellationToken cancellationToken = default)
        {
            using var scope = _securityInsightsRecommendationGetClientDiagnostics.CreateScope("SecurityInsightsRecommendationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsRecommendationGetRestClient.SingleRecommendationAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, recommendationId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsRecommendationResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsRecommendationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/recommendations/{recommendationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Get_SingleRecommendation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsRecommendationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="recommendationId"> Recommendation Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<SecurityInsightsRecommendationResource> GetIfExists(Guid recommendationId, CancellationToken cancellationToken = default)
        {
            using var scope = _securityInsightsRecommendationGetClientDiagnostics.CreateScope("SecurityInsightsRecommendationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsRecommendationGetRestClient.SingleRecommendation(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, recommendationId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsRecommendationResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsRecommendationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsRecommendationResource> IEnumerable<SecurityInsightsRecommendationResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsRecommendationResource> IAsyncEnumerable<SecurityInsightsRecommendationResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
