// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsProductTemplateResource"/> and their operations.
    /// Each <see cref="SecurityInsightsProductTemplateResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="SecurityInsightsProductTemplateCollection"/> instance call the GetSecurityInsightsProductTemplates method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class SecurityInsightsProductTemplateCollection : ArmCollection, IEnumerable<SecurityInsightsProductTemplateResource>, IAsyncEnumerable<SecurityInsightsProductTemplateResource>
    {
        private readonly ClientDiagnostics _securityInsightsProductTemplateProductTemplateClientDiagnostics;
        private readonly ProductTemplateRestOperations _securityInsightsProductTemplateProductTemplateRestClient;
        private readonly ClientDiagnostics _securityInsightsProductTemplateProductTemplatesClientDiagnostics;
        private readonly ProductTemplatesRestOperations _securityInsightsProductTemplateProductTemplatesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsProductTemplateCollection"/> class for mocking. </summary>
        protected SecurityInsightsProductTemplateCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsProductTemplateCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsProductTemplateCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsProductTemplateProductTemplateClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsProductTemplateResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsProductTemplateResource.ResourceType, out string securityInsightsProductTemplateProductTemplateApiVersion);
            _securityInsightsProductTemplateProductTemplateRestClient = new ProductTemplateRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsProductTemplateProductTemplateApiVersion);
            _securityInsightsProductTemplateProductTemplatesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsProductTemplateResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsProductTemplateResource.ResourceType, out string securityInsightsProductTemplateProductTemplatesApiVersion);
            _securityInsightsProductTemplateProductTemplatesRestClient = new ProductTemplatesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsProductTemplateProductTemplatesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a template by its identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentproducttemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsProductTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsProductTemplateResource>> GetAsync(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsProductTemplateProductTemplateClientDiagnostics.CreateScope("SecurityInsightsProductTemplateCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsProductTemplateProductTemplateRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsProductTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a template by its identifier.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentproducttemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsProductTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual Response<SecurityInsightsProductTemplateResource> Get(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsProductTemplateProductTemplateClientDiagnostics.CreateScope("SecurityInsightsProductTemplateCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsProductTemplateProductTemplateRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsProductTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all templates in the catalog.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentProductTemplates</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductTemplates_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsProductTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsProductTemplateResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsProductTemplateResource> GetAllAsync(SecurityInsightsProductTemplateCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new SecurityInsightsProductTemplateCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsProductTemplateProductTemplatesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, options.Filter, options.OrderBy, options.Search, options.Count, options.Top, options.Skip, options.SkipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsProductTemplateProductTemplatesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, options.Filter, options.OrderBy, options.Search, options.Count, options.Top, options.Skip, options.SkipToken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsProductTemplateResource(Client, SecurityInsightsProductTemplateData.DeserializeSecurityInsightsProductTemplateData(e)), _securityInsightsProductTemplateProductTemplatesClientDiagnostics, Pipeline, "SecurityInsightsProductTemplateCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all templates in the catalog.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentProductTemplates</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductTemplates_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsProductTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsProductTemplateResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsProductTemplateResource> GetAll(SecurityInsightsProductTemplateCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new SecurityInsightsProductTemplateCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsProductTemplateProductTemplatesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, options.Filter, options.OrderBy, options.Search, options.Count, options.Top, options.Skip, options.SkipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsProductTemplateProductTemplatesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, options.Filter, options.OrderBy, options.Search, options.Count, options.Top, options.Skip, options.SkipToken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsProductTemplateResource(Client, SecurityInsightsProductTemplateData.DeserializeSecurityInsightsProductTemplateData(e)), _securityInsightsProductTemplateProductTemplatesClientDiagnostics, Pipeline, "SecurityInsightsProductTemplateCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentproducttemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsProductTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsProductTemplateProductTemplateClientDiagnostics.CreateScope("SecurityInsightsProductTemplateCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsProductTemplateProductTemplateRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentproducttemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsProductTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual Response<bool> Exists(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsProductTemplateProductTemplateClientDiagnostics.CreateScope("SecurityInsightsProductTemplateCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsProductTemplateProductTemplateRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentproducttemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsProductTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsProductTemplateResource>> GetIfExistsAsync(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsProductTemplateProductTemplateClientDiagnostics.CreateScope("SecurityInsightsProductTemplateCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsProductTemplateProductTemplateRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsProductTemplateResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsProductTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/contentproducttemplates/{templateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>ProductTemplate_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsProductTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="templateId"> template Id. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="templateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="templateId"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsProductTemplateResource> GetIfExists(string templateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(templateId, nameof(templateId));

            using var scope = _securityInsightsProductTemplateProductTemplateClientDiagnostics.CreateScope("SecurityInsightsProductTemplateCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsProductTemplateProductTemplateRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, templateId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsProductTemplateResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsProductTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsProductTemplateResource> IEnumerable<SecurityInsightsProductTemplateResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsProductTemplateResource> IAsyncEnumerable<SecurityInsightsProductTemplateResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
