// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    public partial class SecurityInsightsProductPackageData : IUtf8JsonSerializable, IJsonModel<SecurityInsightsProductPackageData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SecurityInsightsProductPackageData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SecurityInsightsProductPackageData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsProductPackageData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityInsightsProductPackageData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsDefined(ETag))
            {
                writer.WritePropertyName("etag"u8);
                writer.WriteStringValue(ETag.Value.ToString());
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(ContentId))
            {
                writer.WritePropertyName("contentId"u8);
                writer.WriteStringValue(ContentId);
            }
            if (Optional.IsDefined(ContentProductId))
            {
                writer.WritePropertyName("contentProductId"u8);
                writer.WriteStringValue(ContentProductId);
            }
            if (Optional.IsDefined(ContentKind))
            {
                writer.WritePropertyName("contentKind"u8);
                writer.WriteStringValue(ContentKind.Value.ToString());
            }
            if (Optional.IsDefined(ContentSchemaVersion))
            {
                writer.WritePropertyName("contentSchemaVersion"u8);
                writer.WriteStringValue(ContentSchemaVersion);
            }
            if (Optional.IsDefined(IsNew))
            {
                writer.WritePropertyName("isNew"u8);
                writer.WriteStringValue(IsNew.Value.ToString());
            }
            if (Optional.IsDefined(IsPreview))
            {
                writer.WritePropertyName("isPreview"u8);
                writer.WriteStringValue(IsPreview.Value.ToString());
            }
            if (Optional.IsDefined(IsFeatured))
            {
                writer.WritePropertyName("isFeatured"u8);
                writer.WriteStringValue(IsFeatured.Value.ToString());
            }
            if (Optional.IsDefined(IsDeprecated))
            {
                writer.WritePropertyName("isDeprecated"u8);
                writer.WriteStringValue(IsDeprecated.Value.ToString());
            }
            if (Optional.IsDefined(Version))
            {
                writer.WritePropertyName("version"u8);
                writer.WriteStringValue(Version);
            }
            if (Optional.IsDefined(DisplayName))
            {
                writer.WritePropertyName("displayName"u8);
                writer.WriteStringValue(DisplayName);
            }
            if (Optional.IsDefined(Description))
            {
                writer.WritePropertyName("description"u8);
                writer.WriteStringValue(Description);
            }
            if (Optional.IsDefined(PublisherDisplayName))
            {
                writer.WritePropertyName("publisherDisplayName"u8);
                writer.WriteStringValue(PublisherDisplayName);
            }
            if (Optional.IsDefined(Source))
            {
                writer.WritePropertyName("source"u8);
                writer.WriteObjectValue(Source, options);
            }
            if (Optional.IsDefined(Author))
            {
                writer.WritePropertyName("author"u8);
                writer.WriteObjectValue(Author, options);
            }
            if (Optional.IsDefined(Support))
            {
                writer.WritePropertyName("support"u8);
                writer.WriteObjectValue(Support, options);
            }
            if (Optional.IsDefined(Dependencies))
            {
                writer.WritePropertyName("dependencies"u8);
                writer.WriteObjectValue(Dependencies, options);
            }
            if (Optional.IsCollectionDefined(Providers))
            {
                writer.WritePropertyName("providers"u8);
                writer.WriteStartArray();
                foreach (var item in Providers)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(FirstPublishOn))
            {
                writer.WritePropertyName("firstPublishDate"u8);
                writer.WriteStringValue(FirstPublishOn.Value, "D");
            }
            if (Optional.IsDefined(LastPublishOn))
            {
                writer.WritePropertyName("lastPublishDate"u8);
                writer.WriteStringValue(LastPublishOn.Value, "D");
            }
            if (Optional.IsDefined(Categories))
            {
                writer.WritePropertyName("categories"u8);
                writer.WriteObjectValue(Categories, options);
            }
            if (Optional.IsCollectionDefined(ThreatAnalysisTactics))
            {
                writer.WritePropertyName("threatAnalysisTactics"u8);
                writer.WriteStartArray();
                foreach (var item in ThreatAnalysisTactics)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ThreatAnalysisTechniques))
            {
                writer.WritePropertyName("threatAnalysisTechniques"u8);
                writer.WriteStartArray();
                foreach (var item in ThreatAnalysisTechniques)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(Icon))
            {
                writer.WritePropertyName("icon"u8);
                writer.WriteStringValue(Icon);
            }
            if (Optional.IsDefined(InstalledVersion))
            {
                writer.WritePropertyName("installedVersion"u8);
                writer.WriteStringValue(InstalledVersion);
            }
            if (Optional.IsDefined(MetadataResourceId))
            {
                writer.WritePropertyName("metadataResourceId"u8);
                writer.WriteStringValue(MetadataResourceId);
            }
            if (Optional.IsDefined(PackagedContent))
            {
                writer.WritePropertyName("packagedContent"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(PackagedContent);
#else
                using (JsonDocument document = JsonDocument.Parse(PackagedContent))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            writer.WriteEndObject();
        }

        SecurityInsightsProductPackageData IJsonModel<SecurityInsightsProductPackageData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsProductPackageData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityInsightsProductPackageData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSecurityInsightsProductPackageData(document.RootElement, options);
        }

        internal static SecurityInsightsProductPackageData DeserializeSecurityInsightsProductPackageData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ETag? etag = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string contentId = default;
            string contentProductId = default;
            SecurityInsightsMetadataPackageKind? contentKind = default;
            string contentSchemaVersion = default;
            SecurityInsightsMetadataFlag? isNew = default;
            SecurityInsightsMetadataFlag? isPreview = default;
            SecurityInsightsMetadataFlag? isFeatured = default;
            SecurityInsightsMetadataFlag? isDeprecated = default;
            string version = default;
            string displayName = default;
            string description = default;
            string publisherDisplayName = default;
            SecurityInsightsMetadataSource source = default;
            SecurityInsightsMetadataAuthor author = default;
            SecurityInsightsMetadataSupport support = default;
            SecurityInsightsMetadataDependencies dependencies = default;
            IList<string> providers = default;
            DateTimeOffset? firstPublishDate = default;
            DateTimeOffset? lastPublishDate = default;
            SecurityInsightsMetadataCategories categories = default;
            IList<string> threatAnalysisTactics = default;
            IList<string> threatAnalysisTechniques = default;
            string icon = default;
            string installedVersion = default;
            ResourceIdentifier metadataResourceId = default;
            BinaryData packagedContent = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("etag"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    etag = new ETag(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("contentId"u8))
                        {
                            contentId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("contentProductId"u8))
                        {
                            contentProductId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("contentKind"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            contentKind = new SecurityInsightsMetadataPackageKind(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("contentSchemaVersion"u8))
                        {
                            contentSchemaVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("isNew"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isNew = new SecurityInsightsMetadataFlag(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("isPreview"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isPreview = new SecurityInsightsMetadataFlag(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("isFeatured"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isFeatured = new SecurityInsightsMetadataFlag(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("isDeprecated"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isDeprecated = new SecurityInsightsMetadataFlag(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("version"u8))
                        {
                            version = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("displayName"u8))
                        {
                            displayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("description"u8))
                        {
                            description = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("publisherDisplayName"u8))
                        {
                            publisherDisplayName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("source"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            source = SecurityInsightsMetadataSource.DeserializeSecurityInsightsMetadataSource(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("author"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            author = SecurityInsightsMetadataAuthor.DeserializeSecurityInsightsMetadataAuthor(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("support"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            support = SecurityInsightsMetadataSupport.DeserializeSecurityInsightsMetadataSupport(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("dependencies"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            dependencies = SecurityInsightsMetadataDependencies.DeserializeSecurityInsightsMetadataDependencies(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("providers"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            providers = array;
                            continue;
                        }
                        if (property0.NameEquals("firstPublishDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            firstPublishDate = property0.Value.GetDateTimeOffset("D");
                            continue;
                        }
                        if (property0.NameEquals("lastPublishDate"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastPublishDate = property0.Value.GetDateTimeOffset("D");
                            continue;
                        }
                        if (property0.NameEquals("categories"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            categories = SecurityInsightsMetadataCategories.DeserializeSecurityInsightsMetadataCategories(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("threatAnalysisTactics"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            threatAnalysisTactics = array;
                            continue;
                        }
                        if (property0.NameEquals("threatAnalysisTechniques"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            threatAnalysisTechniques = array;
                            continue;
                        }
                        if (property0.NameEquals("icon"u8))
                        {
                            icon = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("installedVersion"u8))
                        {
                            installedVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("metadataResourceId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            metadataResourceId = new ResourceIdentifier(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("packagedContent"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            packagedContent = BinaryData.FromString(property0.Value.GetRawText());
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SecurityInsightsProductPackageData(
                id,
                name,
                type,
                systemData,
                contentId,
                contentProductId,
                contentKind,
                contentSchemaVersion,
                isNew,
                isPreview,
                isFeatured,
                isDeprecated,
                version,
                displayName,
                description,
                publisherDisplayName,
                source,
                author,
                support,
                dependencies,
                providers ?? new ChangeTrackingList<string>(),
                firstPublishDate,
                lastPublishDate,
                categories,
                threatAnalysisTactics ?? new ChangeTrackingList<string>(),
                threatAnalysisTechniques ?? new ChangeTrackingList<string>(),
                icon,
                installedVersion,
                metadataResourceId,
                packagedContent,
                etag,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ETag), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  etag: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ETag))
                {
                    builder.Append("  etag: ");
                    builder.AppendLine($"'{ETag.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ContentId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    contentId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ContentId))
                {
                    builder.Append("    contentId: ");
                    if (ContentId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ContentId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ContentId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ContentProductId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    contentProductId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ContentProductId))
                {
                    builder.Append("    contentProductId: ");
                    if (ContentProductId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ContentProductId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ContentProductId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ContentKind), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    contentKind: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ContentKind))
                {
                    builder.Append("    contentKind: ");
                    builder.AppendLine($"'{ContentKind.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ContentSchemaVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    contentSchemaVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ContentSchemaVersion))
                {
                    builder.Append("    contentSchemaVersion: ");
                    if (ContentSchemaVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ContentSchemaVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ContentSchemaVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsNew), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isNew: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsNew))
                {
                    builder.Append("    isNew: ");
                    builder.AppendLine($"'{IsNew.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsPreview), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isPreview: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsPreview))
                {
                    builder.Append("    isPreview: ");
                    builder.AppendLine($"'{IsPreview.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsFeatured), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isFeatured: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsFeatured))
                {
                    builder.Append("    isFeatured: ");
                    builder.AppendLine($"'{IsFeatured.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsDeprecated), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isDeprecated: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsDeprecated))
                {
                    builder.Append("    isDeprecated: ");
                    builder.AppendLine($"'{IsDeprecated.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Version), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    version: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Version))
                {
                    builder.Append("    version: ");
                    if (Version.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Version}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Version}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    displayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DisplayName))
                {
                    builder.Append("    displayName: ");
                    if (DisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Description), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    description: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Description))
                {
                    builder.Append("    description: ");
                    if (Description.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Description}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Description}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PublisherDisplayName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    publisherDisplayName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PublisherDisplayName))
                {
                    builder.Append("    publisherDisplayName: ");
                    if (PublisherDisplayName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{PublisherDisplayName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{PublisherDisplayName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Source), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    source: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Source))
                {
                    builder.Append("    source: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Source, options, 4, false, "    source: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Author), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    author: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Author))
                {
                    builder.Append("    author: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Author, options, 4, false, "    author: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Support), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    support: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Support))
                {
                    builder.Append("    support: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Support, options, 4, false, "    support: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Dependencies), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    dependencies: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Dependencies))
                {
                    builder.Append("    dependencies: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Dependencies, options, 4, false, "    dependencies: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Providers), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    providers: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Providers))
                {
                    if (Providers.Any())
                    {
                        builder.Append("    providers: ");
                        builder.AppendLine("[");
                        foreach (var item in Providers)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FirstPublishOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    firstPublishDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FirstPublishOn))
                {
                    builder.Append("    firstPublishDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(FirstPublishOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastPublishOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastPublishDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastPublishOn))
                {
                    builder.Append("    lastPublishDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastPublishOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Categories), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    categories: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Categories))
                {
                    builder.Append("    categories: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Categories, options, 4, false, "    categories: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ThreatAnalysisTactics), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    threatAnalysisTactics: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ThreatAnalysisTactics))
                {
                    if (ThreatAnalysisTactics.Any())
                    {
                        builder.Append("    threatAnalysisTactics: ");
                        builder.AppendLine("[");
                        foreach (var item in ThreatAnalysisTactics)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ThreatAnalysisTechniques), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    threatAnalysisTechniques: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ThreatAnalysisTechniques))
                {
                    if (ThreatAnalysisTechniques.Any())
                    {
                        builder.Append("    threatAnalysisTechniques: ");
                        builder.AppendLine("[");
                        foreach (var item in ThreatAnalysisTechniques)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Icon), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    icon: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Icon))
                {
                    builder.Append("    icon: ");
                    if (Icon.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Icon}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Icon}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InstalledVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    installedVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InstalledVersion))
                {
                    builder.Append("    installedVersion: ");
                    if (InstalledVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{InstalledVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{InstalledVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MetadataResourceId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    metadataResourceId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MetadataResourceId))
                {
                    builder.Append("    metadataResourceId: ");
                    builder.AppendLine($"'{MetadataResourceId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PackagedContent), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    packagedContent: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(PackagedContent))
                {
                    builder.Append("    packagedContent: ");
                    builder.AppendLine($"'{PackagedContent.ToString()}'");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SecurityInsightsProductPackageData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsProductPackageData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SecurityInsightsProductPackageData)} does not support writing '{options.Format}' format.");
            }
        }

        SecurityInsightsProductPackageData IPersistableModel<SecurityInsightsProductPackageData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsProductPackageData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSecurityInsightsProductPackageData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SecurityInsightsProductPackageData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SecurityInsightsProductPackageData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
