// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsOfficeConsentResource"/> and their operations.
    /// Each <see cref="SecurityInsightsOfficeConsentResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="SecurityInsightsOfficeConsentCollection"/> instance call the GetSecurityInsightsOfficeConsents method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class SecurityInsightsOfficeConsentCollection : ArmCollection, IEnumerable<SecurityInsightsOfficeConsentResource>, IAsyncEnumerable<SecurityInsightsOfficeConsentResource>
    {
        private readonly ClientDiagnostics _securityInsightsOfficeConsentOfficeConsentsClientDiagnostics;
        private readonly OfficeConsentsRestOperations _securityInsightsOfficeConsentOfficeConsentsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsOfficeConsentCollection"/> class for mocking. </summary>
        protected SecurityInsightsOfficeConsentCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsOfficeConsentCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsOfficeConsentCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsOfficeConsentOfficeConsentsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsOfficeConsentResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsOfficeConsentResource.ResourceType, out string securityInsightsOfficeConsentOfficeConsentsApiVersion);
            _securityInsightsOfficeConsentOfficeConsentsRestClient = new OfficeConsentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsOfficeConsentOfficeConsentsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets an office365 consent.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/officeConsents/{consentId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OfficeConsents_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsOfficeConsentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="consentId"> consent ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="consentId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="consentId"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsOfficeConsentResource>> GetAsync(string consentId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(consentId, nameof(consentId));

            using var scope = _securityInsightsOfficeConsentOfficeConsentsClientDiagnostics.CreateScope("SecurityInsightsOfficeConsentCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsOfficeConsentOfficeConsentsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, consentId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsOfficeConsentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an office365 consent.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/officeConsents/{consentId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OfficeConsents_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsOfficeConsentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="consentId"> consent ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="consentId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="consentId"/> is null. </exception>
        public virtual Response<SecurityInsightsOfficeConsentResource> Get(string consentId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(consentId, nameof(consentId));

            using var scope = _securityInsightsOfficeConsentOfficeConsentsClientDiagnostics.CreateScope("SecurityInsightsOfficeConsentCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsOfficeConsentOfficeConsentsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, consentId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsOfficeConsentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all office365 consents.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/officeConsents</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OfficeConsents_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsOfficeConsentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsOfficeConsentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsOfficeConsentResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsOfficeConsentOfficeConsentsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsOfficeConsentOfficeConsentsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsOfficeConsentResource(Client, SecurityInsightsOfficeConsentData.DeserializeSecurityInsightsOfficeConsentData(e)), _securityInsightsOfficeConsentOfficeConsentsClientDiagnostics, Pipeline, "SecurityInsightsOfficeConsentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all office365 consents.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/officeConsents</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OfficeConsents_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsOfficeConsentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsOfficeConsentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsOfficeConsentResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsOfficeConsentOfficeConsentsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsOfficeConsentOfficeConsentsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsOfficeConsentResource(Client, SecurityInsightsOfficeConsentData.DeserializeSecurityInsightsOfficeConsentData(e)), _securityInsightsOfficeConsentOfficeConsentsClientDiagnostics, Pipeline, "SecurityInsightsOfficeConsentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/officeConsents/{consentId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OfficeConsents_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsOfficeConsentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="consentId"> consent ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="consentId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="consentId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string consentId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(consentId, nameof(consentId));

            using var scope = _securityInsightsOfficeConsentOfficeConsentsClientDiagnostics.CreateScope("SecurityInsightsOfficeConsentCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsOfficeConsentOfficeConsentsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, consentId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/officeConsents/{consentId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OfficeConsents_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsOfficeConsentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="consentId"> consent ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="consentId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="consentId"/> is null. </exception>
        public virtual Response<bool> Exists(string consentId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(consentId, nameof(consentId));

            using var scope = _securityInsightsOfficeConsentOfficeConsentsClientDiagnostics.CreateScope("SecurityInsightsOfficeConsentCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsOfficeConsentOfficeConsentsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, consentId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/officeConsents/{consentId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OfficeConsents_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsOfficeConsentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="consentId"> consent ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="consentId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="consentId"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsOfficeConsentResource>> GetIfExistsAsync(string consentId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(consentId, nameof(consentId));

            using var scope = _securityInsightsOfficeConsentOfficeConsentsClientDiagnostics.CreateScope("SecurityInsightsOfficeConsentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsOfficeConsentOfficeConsentsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, consentId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsOfficeConsentResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsOfficeConsentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/officeConsents/{consentId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>OfficeConsents_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsOfficeConsentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="consentId"> consent ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="consentId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="consentId"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsOfficeConsentResource> GetIfExists(string consentId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(consentId, nameof(consentId));

            using var scope = _securityInsightsOfficeConsentOfficeConsentsClientDiagnostics.CreateScope("SecurityInsightsOfficeConsentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsOfficeConsentOfficeConsentsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, consentId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsOfficeConsentResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsOfficeConsentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsOfficeConsentResource> IEnumerable<SecurityInsightsOfficeConsentResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsOfficeConsentResource> IAsyncEnumerable<SecurityInsightsOfficeConsentResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
