// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary> A class representing the SecurityInsightsIncidentTask data model. </summary>
    public partial class SecurityInsightsIncidentTaskData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsIncidentTaskData"/>. </summary>
        /// <param name="title"> The title of the task. </param>
        /// <param name="status"></param>
        /// <exception cref="ArgumentNullException"> <paramref name="title"/> is null. </exception>
        public SecurityInsightsIncidentTaskData(string title, IncidentTaskStatus status)
        {
            Argument.AssertNotNull(title, nameof(title));

            Title = title;
            Status = status;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsIncidentTaskData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="title"> The title of the task. </param>
        /// <param name="description"> The description of the task. </param>
        /// <param name="status"></param>
        /// <param name="createdOn"> The time the task was created. </param>
        /// <param name="lastModifiedOn"> The last time the task was updated. </param>
        /// <param name="createdBy"> Information on the client (user or application) that made some action. </param>
        /// <param name="lastModifiedBy"> Information on the client (user or application) that made some action. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsIncidentTaskData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string title, string description, IncidentTaskStatus status, DateTimeOffset? createdOn, DateTimeOffset? lastModifiedOn, SecurityInsightsClientInfo createdBy, SecurityInsightsClientInfo lastModifiedBy, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Title = title;
            Description = description;
            Status = status;
            CreatedOn = createdOn;
            LastModifiedOn = lastModifiedOn;
            CreatedBy = createdBy;
            LastModifiedBy = lastModifiedBy;
            ETag = etag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsIncidentTaskData"/> for deserialization. </summary>
        internal SecurityInsightsIncidentTaskData()
        {
        }

        /// <summary> The title of the task. </summary>
        [WirePath("properties.title")]
        public string Title { get; set; }
        /// <summary> The description of the task. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> Gets or sets the status. </summary>
        [WirePath("properties.status")]
        public IncidentTaskStatus Status { get; set; }
        /// <summary> The time the task was created. </summary>
        [WirePath("properties.createdTimeUtc")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The last time the task was updated. </summary>
        [WirePath("properties.lastModifiedTimeUtc")]
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> Information on the client (user or application) that made some action. </summary>
        [WirePath("properties.createdBy")]
        public SecurityInsightsClientInfo CreatedBy { get; set; }
        /// <summary> Information on the client (user or application) that made some action. </summary>
        [WirePath("properties.lastModifiedBy")]
        public SecurityInsightsClientInfo LastModifiedBy { get; set; }
        /// <summary> Etag of the azure resource. </summary>
        [WirePath("etag")]
        public ETag? ETag { get; set; }
    }
}
