// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsIncidentTaskResource"/> and their operations.
    /// Each <see cref="SecurityInsightsIncidentTaskResource"/> in the collection will belong to the same instance of <see cref="SecurityInsightsIncidentResource"/>.
    /// To get a <see cref="SecurityInsightsIncidentTaskCollection"/> instance call the GetSecurityInsightsIncidentTasks method from an instance of <see cref="SecurityInsightsIncidentResource"/>.
    /// </summary>
    public partial class SecurityInsightsIncidentTaskCollection : ArmCollection, IEnumerable<SecurityInsightsIncidentTaskResource>, IAsyncEnumerable<SecurityInsightsIncidentTaskResource>
    {
        private readonly ClientDiagnostics _securityInsightsIncidentTaskIncidentTasksClientDiagnostics;
        private readonly IncidentTasksRestOperations _securityInsightsIncidentTaskIncidentTasksRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsIncidentTaskCollection"/> class for mocking. </summary>
        protected SecurityInsightsIncidentTaskCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsIncidentTaskCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsIncidentTaskCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsIncidentTaskIncidentTasksClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsIncidentTaskResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsIncidentTaskResource.ResourceType, out string securityInsightsIncidentTaskIncidentTasksApiVersion);
            _securityInsightsIncidentTaskIncidentTasksRestClient = new IncidentTasksRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsIncidentTaskIncidentTasksApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SecurityInsightsIncidentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SecurityInsightsIncidentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates the incident task.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks/{incidentTaskId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IncidentTasks_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsIncidentTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="incidentTaskId"> Incident task ID. </param>
        /// <param name="data"> The incident task. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="incidentTaskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="incidentTaskId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SecurityInsightsIncidentTaskResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string incidentTaskId, SecurityInsightsIncidentTaskData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(incidentTaskId, nameof(incidentTaskId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsIncidentTaskIncidentTasksClientDiagnostics.CreateScope("SecurityInsightsIncidentTaskCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _securityInsightsIncidentTaskIncidentTasksRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, incidentTaskId, data, cancellationToken).ConfigureAwait(false);
                var uri = _securityInsightsIncidentTaskIncidentTasksRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, incidentTaskId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsIncidentTaskResource>(Response.FromValue(new SecurityInsightsIncidentTaskResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates the incident task.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks/{incidentTaskId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IncidentTasks_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsIncidentTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="incidentTaskId"> Incident task ID. </param>
        /// <param name="data"> The incident task. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="incidentTaskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="incidentTaskId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SecurityInsightsIncidentTaskResource> CreateOrUpdate(WaitUntil waitUntil, string incidentTaskId, SecurityInsightsIncidentTaskData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(incidentTaskId, nameof(incidentTaskId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsIncidentTaskIncidentTasksClientDiagnostics.CreateScope("SecurityInsightsIncidentTaskCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _securityInsightsIncidentTaskIncidentTasksRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, incidentTaskId, data, cancellationToken);
                var uri = _securityInsightsIncidentTaskIncidentTasksRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, incidentTaskId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsIncidentTaskResource>(Response.FromValue(new SecurityInsightsIncidentTaskResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an incident task.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks/{incidentTaskId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IncidentTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsIncidentTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="incidentTaskId"> Incident task ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="incidentTaskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="incidentTaskId"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsIncidentTaskResource>> GetAsync(string incidentTaskId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(incidentTaskId, nameof(incidentTaskId));

            using var scope = _securityInsightsIncidentTaskIncidentTasksClientDiagnostics.CreateScope("SecurityInsightsIncidentTaskCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsIncidentTaskIncidentTasksRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, incidentTaskId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsIncidentTaskResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an incident task.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks/{incidentTaskId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IncidentTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsIncidentTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="incidentTaskId"> Incident task ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="incidentTaskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="incidentTaskId"/> is null. </exception>
        public virtual Response<SecurityInsightsIncidentTaskResource> Get(string incidentTaskId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(incidentTaskId, nameof(incidentTaskId));

            using var scope = _securityInsightsIncidentTaskIncidentTasksClientDiagnostics.CreateScope("SecurityInsightsIncidentTaskCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsIncidentTaskIncidentTasksRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, incidentTaskId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsIncidentTaskResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all incident tasks.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IncidentTasks_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsIncidentTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsIncidentTaskResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsIncidentTaskResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsIncidentTaskIncidentTasksRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsIncidentTaskIncidentTasksRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsIncidentTaskResource(Client, SecurityInsightsIncidentTaskData.DeserializeSecurityInsightsIncidentTaskData(e)), _securityInsightsIncidentTaskIncidentTasksClientDiagnostics, Pipeline, "SecurityInsightsIncidentTaskCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all incident tasks.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IncidentTasks_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsIncidentTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsIncidentTaskResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsIncidentTaskResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsIncidentTaskIncidentTasksRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsIncidentTaskIncidentTasksRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsIncidentTaskResource(Client, SecurityInsightsIncidentTaskData.DeserializeSecurityInsightsIncidentTaskData(e)), _securityInsightsIncidentTaskIncidentTasksClientDiagnostics, Pipeline, "SecurityInsightsIncidentTaskCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks/{incidentTaskId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IncidentTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsIncidentTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="incidentTaskId"> Incident task ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="incidentTaskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="incidentTaskId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string incidentTaskId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(incidentTaskId, nameof(incidentTaskId));

            using var scope = _securityInsightsIncidentTaskIncidentTasksClientDiagnostics.CreateScope("SecurityInsightsIncidentTaskCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsIncidentTaskIncidentTasksRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, incidentTaskId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks/{incidentTaskId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IncidentTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsIncidentTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="incidentTaskId"> Incident task ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="incidentTaskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="incidentTaskId"/> is null. </exception>
        public virtual Response<bool> Exists(string incidentTaskId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(incidentTaskId, nameof(incidentTaskId));

            using var scope = _securityInsightsIncidentTaskIncidentTasksClientDiagnostics.CreateScope("SecurityInsightsIncidentTaskCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsIncidentTaskIncidentTasksRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, incidentTaskId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks/{incidentTaskId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IncidentTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsIncidentTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="incidentTaskId"> Incident task ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="incidentTaskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="incidentTaskId"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsIncidentTaskResource>> GetIfExistsAsync(string incidentTaskId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(incidentTaskId, nameof(incidentTaskId));

            using var scope = _securityInsightsIncidentTaskIncidentTasksClientDiagnostics.CreateScope("SecurityInsightsIncidentTaskCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsIncidentTaskIncidentTasksRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, incidentTaskId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsIncidentTaskResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsIncidentTaskResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/incidents/{incidentId}/tasks/{incidentTaskId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>IncidentTasks_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsIncidentTaskResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="incidentTaskId"> Incident task ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="incidentTaskId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="incidentTaskId"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsIncidentTaskResource> GetIfExists(string incidentTaskId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(incidentTaskId, nameof(incidentTaskId));

            using var scope = _securityInsightsIncidentTaskIncidentTasksClientDiagnostics.CreateScope("SecurityInsightsIncidentTaskCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsIncidentTaskIncidentTasksRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, incidentTaskId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsIncidentTaskResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsIncidentTaskResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsIncidentTaskResource> IEnumerable<SecurityInsightsIncidentTaskResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsIncidentTaskResource> IAsyncEnumerable<SecurityInsightsIncidentTaskResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
