// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsHuntRelationResource"/> and their operations.
    /// Each <see cref="SecurityInsightsHuntRelationResource"/> in the collection will belong to the same instance of <see cref="SecurityInsightsHuntResource"/>.
    /// To get a <see cref="SecurityInsightsHuntRelationCollection"/> instance call the GetSecurityInsightsHuntRelations method from an instance of <see cref="SecurityInsightsHuntResource"/>.
    /// </summary>
    public partial class SecurityInsightsHuntRelationCollection : ArmCollection, IEnumerable<SecurityInsightsHuntRelationResource>, IAsyncEnumerable<SecurityInsightsHuntRelationResource>
    {
        private readonly ClientDiagnostics _securityInsightsHuntRelationHuntRelationsClientDiagnostics;
        private readonly HuntRelationsRestOperations _securityInsightsHuntRelationHuntRelationsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsHuntRelationCollection"/> class for mocking. </summary>
        protected SecurityInsightsHuntRelationCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsHuntRelationCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsHuntRelationCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsHuntRelationHuntRelationsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsHuntRelationResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsHuntRelationResource.ResourceType, out string securityInsightsHuntRelationHuntRelationsApiVersion);
            _securityInsightsHuntRelationHuntRelationsRestClient = new HuntRelationsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsHuntRelationHuntRelationsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SecurityInsightsHuntResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SecurityInsightsHuntResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a hunt relation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations/{huntRelationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HuntRelations_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="huntRelationId"> The hunt relation id (GUID). </param>
        /// <param name="data"> The hunt relation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntRelationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntRelationId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SecurityInsightsHuntRelationResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string huntRelationId, SecurityInsightsHuntRelationData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntRelationId, nameof(huntRelationId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsHuntRelationHuntRelationsClientDiagnostics.CreateScope("SecurityInsightsHuntRelationCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _securityInsightsHuntRelationHuntRelationsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, huntRelationId, data, cancellationToken).ConfigureAwait(false);
                var uri = _securityInsightsHuntRelationHuntRelationsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, huntRelationId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsHuntRelationResource>(Response.FromValue(new SecurityInsightsHuntRelationResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a hunt relation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations/{huntRelationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HuntRelations_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="huntRelationId"> The hunt relation id (GUID). </param>
        /// <param name="data"> The hunt relation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntRelationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntRelationId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SecurityInsightsHuntRelationResource> CreateOrUpdate(WaitUntil waitUntil, string huntRelationId, SecurityInsightsHuntRelationData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntRelationId, nameof(huntRelationId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsHuntRelationHuntRelationsClientDiagnostics.CreateScope("SecurityInsightsHuntRelationCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _securityInsightsHuntRelationHuntRelationsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, huntRelationId, data, cancellationToken);
                var uri = _securityInsightsHuntRelationHuntRelationsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, huntRelationId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsHuntRelationResource>(Response.FromValue(new SecurityInsightsHuntRelationResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a hunt relation
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations/{huntRelationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HuntRelations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntRelationId"> The hunt relation id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntRelationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntRelationId"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsHuntRelationResource>> GetAsync(string huntRelationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntRelationId, nameof(huntRelationId));

            using var scope = _securityInsightsHuntRelationHuntRelationsClientDiagnostics.CreateScope("SecurityInsightsHuntRelationCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsHuntRelationHuntRelationsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, huntRelationId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsHuntRelationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a hunt relation
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations/{huntRelationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HuntRelations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntRelationId"> The hunt relation id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntRelationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntRelationId"/> is null. </exception>
        public virtual Response<SecurityInsightsHuntRelationResource> Get(string huntRelationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntRelationId, nameof(huntRelationId));

            using var scope = _securityInsightsHuntRelationHuntRelationsClientDiagnostics.CreateScope("SecurityInsightsHuntRelationCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsHuntRelationHuntRelationsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, huntRelationId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsHuntRelationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all hunt relations
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HuntRelations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> Filters the results, based on a Boolean condition. Optional. </param>
        /// <param name="orderBy"> Sorts the results. Optional. </param>
        /// <param name="top"> Returns only the first n results. Optional. </param>
        /// <param name="skipToken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsHuntRelationResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsHuntRelationResource> GetAllAsync(string filter = null, string orderBy = null, int? top = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsHuntRelationHuntRelationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, orderBy, top, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsHuntRelationHuntRelationsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, orderBy, top, skipToken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsHuntRelationResource(Client, SecurityInsightsHuntRelationData.DeserializeSecurityInsightsHuntRelationData(e)), _securityInsightsHuntRelationHuntRelationsClientDiagnostics, Pipeline, "SecurityInsightsHuntRelationCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all hunt relations
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HuntRelations_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> Filters the results, based on a Boolean condition. Optional. </param>
        /// <param name="orderBy"> Sorts the results. Optional. </param>
        /// <param name="top"> Returns only the first n results. Optional. </param>
        /// <param name="skipToken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsHuntRelationResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsHuntRelationResource> GetAll(string filter = null, string orderBy = null, int? top = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsHuntRelationHuntRelationsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, orderBy, top, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsHuntRelationHuntRelationsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, filter, orderBy, top, skipToken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsHuntRelationResource(Client, SecurityInsightsHuntRelationData.DeserializeSecurityInsightsHuntRelationData(e)), _securityInsightsHuntRelationHuntRelationsClientDiagnostics, Pipeline, "SecurityInsightsHuntRelationCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations/{huntRelationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HuntRelations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntRelationId"> The hunt relation id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntRelationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntRelationId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string huntRelationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntRelationId, nameof(huntRelationId));

            using var scope = _securityInsightsHuntRelationHuntRelationsClientDiagnostics.CreateScope("SecurityInsightsHuntRelationCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsHuntRelationHuntRelationsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, huntRelationId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations/{huntRelationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HuntRelations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntRelationId"> The hunt relation id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntRelationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntRelationId"/> is null. </exception>
        public virtual Response<bool> Exists(string huntRelationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntRelationId, nameof(huntRelationId));

            using var scope = _securityInsightsHuntRelationHuntRelationsClientDiagnostics.CreateScope("SecurityInsightsHuntRelationCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsHuntRelationHuntRelationsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, huntRelationId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations/{huntRelationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HuntRelations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntRelationId"> The hunt relation id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntRelationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntRelationId"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsHuntRelationResource>> GetIfExistsAsync(string huntRelationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntRelationId, nameof(huntRelationId));

            using var scope = _securityInsightsHuntRelationHuntRelationsClientDiagnostics.CreateScope("SecurityInsightsHuntRelationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsHuntRelationHuntRelationsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, huntRelationId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsHuntRelationResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsHuntRelationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}/relations/{huntRelationId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>HuntRelations_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntRelationId"> The hunt relation id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntRelationId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntRelationId"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsHuntRelationResource> GetIfExists(string huntRelationId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntRelationId, nameof(huntRelationId));

            using var scope = _securityInsightsHuntRelationHuntRelationsClientDiagnostics.CreateScope("SecurityInsightsHuntRelationCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsHuntRelationHuntRelationsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, huntRelationId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsHuntRelationResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsHuntRelationResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsHuntRelationResource> IEnumerable<SecurityInsightsHuntRelationResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsHuntRelationResource> IAsyncEnumerable<SecurityInsightsHuntRelationResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
