// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing the SecurityInsightsHunt data model.
    /// Represents a Hunt in Azure Security Insights.
    /// </summary>
    public partial class SecurityInsightsHuntData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsHuntData"/>. </summary>
        public SecurityInsightsHuntData()
        {
            AttackTactics = new ChangeTrackingList<SecurityInsightsAttackTactic>();
            AttackTechniques = new ChangeTrackingList<string>();
            Labels = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsHuntData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="displayName"> The display name of the hunt. </param>
        /// <param name="description"> The description of the hunt. </param>
        /// <param name="status"> The status of the hunt. </param>
        /// <param name="hypothesisStatus"> The hypothesis status of the hunt. </param>
        /// <param name="attackTactics"> A list of mitre attack tactics the hunt is associated with. </param>
        /// <param name="attackTechniques"> A list of a mitre attack techniques the hunt is associated with. </param>
        /// <param name="labels"> List of labels relevant to this hunt. </param>
        /// <param name="owner"> Describes a user that the hunt is assigned to. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsHuntData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string displayName, string description, HuntStatus? status, HypothesisStatus? hypothesisStatus, IList<SecurityInsightsAttackTactic> attackTactics, IList<string> attackTechniques, IList<string> labels, SecurityInsightsHuntOwner owner, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DisplayName = displayName;
            Description = description;
            Status = status;
            HypothesisStatus = hypothesisStatus;
            AttackTactics = attackTactics;
            AttackTechniques = attackTechniques;
            Labels = labels;
            Owner = owner;
            ETag = etag;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The display name of the hunt. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> The description of the hunt. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> The status of the hunt. </summary>
        [WirePath("properties.status")]
        public HuntStatus? Status { get; set; }
        /// <summary> The hypothesis status of the hunt. </summary>
        [WirePath("properties.hypothesisStatus")]
        public HypothesisStatus? HypothesisStatus { get; set; }
        /// <summary> A list of mitre attack tactics the hunt is associated with. </summary>
        [WirePath("properties.attackTactics")]
        public IList<SecurityInsightsAttackTactic> AttackTactics { get; }
        /// <summary> A list of a mitre attack techniques the hunt is associated with. </summary>
        [WirePath("properties.attackTechniques")]
        public IList<string> AttackTechniques { get; }
        /// <summary> List of labels relevant to this hunt. </summary>
        [WirePath("properties.labels")]
        public IList<string> Labels { get; }
        /// <summary> Describes a user that the hunt is assigned to. </summary>
        [WirePath("properties.owner")]
        public SecurityInsightsHuntOwner Owner { get; set; }
        /// <summary> Etag of the azure resource. </summary>
        [WirePath("etag")]
        public ETag? ETag { get; set; }
    }
}
