// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsHuntResource"/> and their operations.
    /// Each <see cref="SecurityInsightsHuntResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="SecurityInsightsHuntCollection"/> instance call the GetSecurityInsightsHunts method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class SecurityInsightsHuntCollection : ArmCollection, IEnumerable<SecurityInsightsHuntResource>, IAsyncEnumerable<SecurityInsightsHuntResource>
    {
        private readonly ClientDiagnostics _securityInsightsHuntHuntsClientDiagnostics;
        private readonly HuntsRestOperations _securityInsightsHuntHuntsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsHuntCollection"/> class for mocking. </summary>
        protected SecurityInsightsHuntCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsHuntCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsHuntCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsHuntHuntsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsHuntResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsHuntResource.ResourceType, out string securityInsightsHuntHuntsApiVersion);
            _securityInsightsHuntHuntsRestClient = new HuntsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsHuntHuntsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Create or update a hunt
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hunts_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="huntId"> The hunt id (GUID). </param>
        /// <param name="data"> The hunt. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SecurityInsightsHuntResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string huntId, SecurityInsightsHuntData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntId, nameof(huntId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsHuntHuntsClientDiagnostics.CreateScope("SecurityInsightsHuntCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _securityInsightsHuntHuntsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, huntId, data, cancellationToken).ConfigureAwait(false);
                var uri = _securityInsightsHuntHuntsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, huntId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsHuntResource>(Response.FromValue(new SecurityInsightsHuntResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update a hunt
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hunts_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="huntId"> The hunt id (GUID). </param>
        /// <param name="data"> The hunt. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SecurityInsightsHuntResource> CreateOrUpdate(WaitUntil waitUntil, string huntId, SecurityInsightsHuntData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntId, nameof(huntId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsHuntHuntsClientDiagnostics.CreateScope("SecurityInsightsHuntCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _securityInsightsHuntHuntsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, huntId, data, cancellationToken);
                var uri = _securityInsightsHuntHuntsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, huntId, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsHuntResource>(Response.FromValue(new SecurityInsightsHuntResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a hunt, without relations and comments.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hunts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntId"> The hunt id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntId"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsHuntResource>> GetAsync(string huntId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntId, nameof(huntId));

            using var scope = _securityInsightsHuntHuntsClientDiagnostics.CreateScope("SecurityInsightsHuntCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsHuntHuntsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, huntId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsHuntResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a hunt, without relations and comments.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hunts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntId"> The hunt id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntId"/> is null. </exception>
        public virtual Response<SecurityInsightsHuntResource> Get(string huntId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntId, nameof(huntId));

            using var scope = _securityInsightsHuntHuntsClientDiagnostics.CreateScope("SecurityInsightsHuntCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsHuntHuntsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, huntId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsHuntResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all hunts, without relations and comments.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hunts_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> Filters the results, based on a Boolean condition. Optional. </param>
        /// <param name="orderBy"> Sorts the results. Optional. </param>
        /// <param name="top"> Returns only the first n results. Optional. </param>
        /// <param name="skipToken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsHuntResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsHuntResource> GetAllAsync(string filter = null, string orderBy = null, int? top = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsHuntHuntsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, orderBy, top, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsHuntHuntsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, orderBy, top, skipToken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsHuntResource(Client, SecurityInsightsHuntData.DeserializeSecurityInsightsHuntData(e)), _securityInsightsHuntHuntsClientDiagnostics, Pipeline, "SecurityInsightsHuntCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all hunts, without relations and comments.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hunts_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> Filters the results, based on a Boolean condition. Optional. </param>
        /// <param name="orderBy"> Sorts the results. Optional. </param>
        /// <param name="top"> Returns only the first n results. Optional. </param>
        /// <param name="skipToken"> Skiptoken is only used if a previous operation returned a partial result. If a previous response contains a nextLink element, the value of the nextLink element will include a skiptoken parameter that specifies a starting point to use for subsequent calls. Optional. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsHuntResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsHuntResource> GetAll(string filter = null, string orderBy = null, int? top = null, string skipToken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsHuntHuntsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, orderBy, top, skipToken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsHuntHuntsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, filter, orderBy, top, skipToken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsHuntResource(Client, SecurityInsightsHuntData.DeserializeSecurityInsightsHuntData(e)), _securityInsightsHuntHuntsClientDiagnostics, Pipeline, "SecurityInsightsHuntCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hunts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntId"> The hunt id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string huntId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntId, nameof(huntId));

            using var scope = _securityInsightsHuntHuntsClientDiagnostics.CreateScope("SecurityInsightsHuntCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsHuntHuntsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, huntId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hunts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntId"> The hunt id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntId"/> is null. </exception>
        public virtual Response<bool> Exists(string huntId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntId, nameof(huntId));

            using var scope = _securityInsightsHuntHuntsClientDiagnostics.CreateScope("SecurityInsightsHuntCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsHuntHuntsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, huntId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hunts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntId"> The hunt id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntId"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsHuntResource>> GetIfExistsAsync(string huntId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntId, nameof(huntId));

            using var scope = _securityInsightsHuntHuntsClientDiagnostics.CreateScope("SecurityInsightsHuntCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsHuntHuntsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, huntId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsHuntResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsHuntResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/hunts/{huntId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Hunts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsHuntResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="huntId"> The hunt id (GUID). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="huntId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="huntId"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsHuntResource> GetIfExists(string huntId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(huntId, nameof(huntId));

            using var scope = _securityInsightsHuntHuntsClientDiagnostics.CreateScope("SecurityInsightsHuntCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsHuntHuntsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, huntId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsHuntResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsHuntResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsHuntResource> IEnumerable<SecurityInsightsHuntResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsHuntResource> IAsyncEnumerable<SecurityInsightsHuntResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
