// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing the SecurityInsightsFileImport data model.
    /// Represents a file import in Azure Security Insights.
    /// </summary>
    public partial class SecurityInsightsFileImportData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsFileImportData"/>. </summary>
        public SecurityInsightsFileImportData()
        {
            ErrorsPreview = new ChangeTrackingList<SecurityInsightsFileValidationError>();
        }

        /// <summary> Initializes a new instance of <see cref="SecurityInsightsFileImportData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="ingestionMode"> Describes how to ingest the records in the file. </param>
        /// <param name="contentType"> The content type of this file. </param>
        /// <param name="createdOn"> The time the file was imported. </param>
        /// <param name="errorFile"> Represents the error file (if the import was ingested with errors or failed the validation). </param>
        /// <param name="errorsPreview"> An ordered list of some of the errors that were encountered during validation. </param>
        /// <param name="importFile"> Represents the imported file. </param>
        /// <param name="ingestedRecordCount"> The number of records that have been successfully ingested. </param>
        /// <param name="source"> The source for the data in the file. </param>
        /// <param name="state"> The state of the file import. </param>
        /// <param name="totalRecordCount"> The number of records in the file. </param>
        /// <param name="validRecordCount"> The number of records that have passed validation. </param>
        /// <param name="filesValidUntil"> The time the files associated with this import are deleted from the storage account. </param>
        /// <param name="importValidUntil"> The time the file import record is soft deleted from the database and history. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SecurityInsightsFileImportData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IngestionMode? ingestionMode, SecurityInsightsFileImportContentType? contentType, DateTimeOffset? createdOn, SecurityInsightsFileMetadata errorFile, IReadOnlyList<SecurityInsightsFileValidationError> errorsPreview, SecurityInsightsFileMetadata importFile, int? ingestedRecordCount, string source, SecurityInsightsFileImportState? state, int? totalRecordCount, int? validRecordCount, DateTimeOffset? filesValidUntil, DateTimeOffset? importValidUntil, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            IngestionMode = ingestionMode;
            ContentType = contentType;
            CreatedOn = createdOn;
            ErrorFile = errorFile;
            ErrorsPreview = errorsPreview;
            ImportFile = importFile;
            IngestedRecordCount = ingestedRecordCount;
            Source = source;
            State = state;
            TotalRecordCount = totalRecordCount;
            ValidRecordCount = validRecordCount;
            FilesValidUntil = filesValidUntil;
            ImportValidUntil = importValidUntil;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Describes how to ingest the records in the file. </summary>
        [WirePath("properties.ingestionMode")]
        public IngestionMode? IngestionMode { get; set; }
        /// <summary> The content type of this file. </summary>
        [WirePath("properties.contentType")]
        public SecurityInsightsFileImportContentType? ContentType { get; set; }
        /// <summary> The time the file was imported. </summary>
        [WirePath("properties.createdTimeUTC")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Represents the error file (if the import was ingested with errors or failed the validation). </summary>
        [WirePath("properties.errorFile")]
        public SecurityInsightsFileMetadata ErrorFile { get; }
        /// <summary> An ordered list of some of the errors that were encountered during validation. </summary>
        [WirePath("properties.errorsPreview")]
        public IReadOnlyList<SecurityInsightsFileValidationError> ErrorsPreview { get; }
        /// <summary> Represents the imported file. </summary>
        [WirePath("properties.importFile")]
        public SecurityInsightsFileMetadata ImportFile { get; set; }
        /// <summary> The number of records that have been successfully ingested. </summary>
        [WirePath("properties.ingestedRecordCount")]
        public int? IngestedRecordCount { get; }
        /// <summary> The source for the data in the file. </summary>
        [WirePath("properties.source")]
        public string Source { get; set; }
        /// <summary> The state of the file import. </summary>
        [WirePath("properties.state")]
        public SecurityInsightsFileImportState? State { get; }
        /// <summary> The number of records in the file. </summary>
        [WirePath("properties.totalRecordCount")]
        public int? TotalRecordCount { get; }
        /// <summary> The number of records that have passed validation. </summary>
        [WirePath("properties.validRecordCount")]
        public int? ValidRecordCount { get; }
        /// <summary> The time the files associated with this import are deleted from the storage account. </summary>
        [WirePath("properties.filesValidUntilTimeUTC")]
        public DateTimeOffset? FilesValidUntil { get; }
        /// <summary> The time the file import record is soft deleted from the database and history. </summary>
        [WirePath("properties.importValidUntilTimeUTC")]
        public DateTimeOffset? ImportValidUntil { get; }
    }
}
