// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    public partial class SecurityInsightsFileImportData : IUtf8JsonSerializable, IJsonModel<SecurityInsightsFileImportData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SecurityInsightsFileImportData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SecurityInsightsFileImportData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsFileImportData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityInsightsFileImportData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(IngestionMode))
            {
                writer.WritePropertyName("ingestionMode"u8);
                writer.WriteStringValue(IngestionMode.Value.ToString());
            }
            if (Optional.IsDefined(ContentType))
            {
                writer.WritePropertyName("contentType"u8);
                writer.WriteStringValue(ContentType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(CreatedOn))
            {
                writer.WritePropertyName("createdTimeUTC"u8);
                writer.WriteStringValue(CreatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ErrorFile))
            {
                writer.WritePropertyName("errorFile"u8);
                writer.WriteObjectValue(ErrorFile, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ErrorsPreview))
            {
                writer.WritePropertyName("errorsPreview"u8);
                writer.WriteStartArray();
                foreach (var item in ErrorsPreview)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(ImportFile))
            {
                writer.WritePropertyName("importFile"u8);
                writer.WriteObjectValue(ImportFile, options);
            }
            if (options.Format != "W" && Optional.IsDefined(IngestedRecordCount))
            {
                writer.WritePropertyName("ingestedRecordCount"u8);
                writer.WriteNumberValue(IngestedRecordCount.Value);
            }
            if (Optional.IsDefined(Source))
            {
                writer.WritePropertyName("source"u8);
                writer.WriteStringValue(Source);
            }
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(TotalRecordCount))
            {
                writer.WritePropertyName("totalRecordCount"u8);
                writer.WriteNumberValue(TotalRecordCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ValidRecordCount))
            {
                writer.WritePropertyName("validRecordCount"u8);
                writer.WriteNumberValue(ValidRecordCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(FilesValidUntil))
            {
                writer.WritePropertyName("filesValidUntilTimeUTC"u8);
                writer.WriteStringValue(FilesValidUntil.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ImportValidUntil))
            {
                writer.WritePropertyName("importValidUntilTimeUTC"u8);
                writer.WriteStringValue(ImportValidUntil.Value, "O");
            }
            writer.WriteEndObject();
        }

        SecurityInsightsFileImportData IJsonModel<SecurityInsightsFileImportData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsFileImportData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityInsightsFileImportData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSecurityInsightsFileImportData(document.RootElement, options);
        }

        internal static SecurityInsightsFileImportData DeserializeSecurityInsightsFileImportData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            IngestionMode? ingestionMode = default;
            SecurityInsightsFileImportContentType? contentType = default;
            DateTimeOffset? createdTimeUTC = default;
            SecurityInsightsFileMetadata errorFile = default;
            IReadOnlyList<SecurityInsightsFileValidationError> errorsPreview = default;
            SecurityInsightsFileMetadata importFile = default;
            int? ingestedRecordCount = default;
            string source = default;
            SecurityInsightsFileImportState? state = default;
            int? totalRecordCount = default;
            int? validRecordCount = default;
            DateTimeOffset? filesValidUntilTimeUTC = default;
            DateTimeOffset? importValidUntilTimeUTC = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("ingestionMode"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            ingestionMode = new IngestionMode(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("contentType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            contentType = new SecurityInsightsFileImportContentType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("createdTimeUTC"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            createdTimeUTC = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("errorFile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            errorFile = SecurityInsightsFileMetadata.DeserializeSecurityInsightsFileMetadata(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("errorsPreview"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SecurityInsightsFileValidationError> array = new List<SecurityInsightsFileValidationError>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SecurityInsightsFileValidationError.DeserializeSecurityInsightsFileValidationError(item, options));
                            }
                            errorsPreview = array;
                            continue;
                        }
                        if (property0.NameEquals("importFile"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            importFile = SecurityInsightsFileMetadata.DeserializeSecurityInsightsFileMetadata(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("ingestedRecordCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            ingestedRecordCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("source"u8))
                        {
                            source = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("state"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            state = new SecurityInsightsFileImportState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("totalRecordCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            totalRecordCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("validRecordCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            validRecordCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("filesValidUntilTimeUTC"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            filesValidUntilTimeUTC = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("importValidUntilTimeUTC"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            importValidUntilTimeUTC = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SecurityInsightsFileImportData(
                id,
                name,
                type,
                systemData,
                ingestionMode,
                contentType,
                createdTimeUTC,
                errorFile,
                errorsPreview ?? new ChangeTrackingList<SecurityInsightsFileValidationError>(),
                importFile,
                ingestedRecordCount,
                source,
                state,
                totalRecordCount,
                validRecordCount,
                filesValidUntilTimeUTC,
                importValidUntilTimeUTC,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IngestionMode), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    ingestionMode: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IngestionMode))
                {
                    builder.Append("    ingestionMode: ");
                    builder.AppendLine($"'{IngestionMode.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ContentType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    contentType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ContentType))
                {
                    builder.Append("    contentType: ");
                    builder.AppendLine($"'{ContentType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CreatedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    createdTimeUTC: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CreatedOn))
                {
                    builder.Append("    createdTimeUTC: ");
                    var formattedDateTimeString = TypeFormatters.ToString(CreatedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ErrorFile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    errorFile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ErrorFile))
                {
                    builder.Append("    errorFile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ErrorFile, options, 4, false, "    errorFile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ErrorsPreview), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    errorsPreview: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ErrorsPreview))
                {
                    if (ErrorsPreview.Any())
                    {
                        builder.Append("    errorsPreview: ");
                        builder.AppendLine("[");
                        foreach (var item in ErrorsPreview)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    errorsPreview: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ImportFile), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    importFile: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ImportFile))
                {
                    builder.Append("    importFile: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ImportFile, options, 4, false, "    importFile: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IngestedRecordCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    ingestedRecordCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IngestedRecordCount))
                {
                    builder.Append("    ingestedRecordCount: ");
                    builder.AppendLine($"{IngestedRecordCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Source), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    source: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Source))
                {
                    builder.Append("    source: ");
                    if (Source.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Source}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Source}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(State), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    state: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(State))
                {
                    builder.Append("    state: ");
                    builder.AppendLine($"'{State.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TotalRecordCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    totalRecordCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TotalRecordCount))
                {
                    builder.Append("    totalRecordCount: ");
                    builder.AppendLine($"{TotalRecordCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ValidRecordCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    validRecordCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ValidRecordCount))
                {
                    builder.Append("    validRecordCount: ");
                    builder.AppendLine($"{ValidRecordCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FilesValidUntil), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    filesValidUntilTimeUTC: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FilesValidUntil))
                {
                    builder.Append("    filesValidUntilTimeUTC: ");
                    var formattedDateTimeString = TypeFormatters.ToString(FilesValidUntil.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ImportValidUntil), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    importValidUntilTimeUTC: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ImportValidUntil))
                {
                    builder.Append("    importValidUntilTimeUTC: ");
                    var formattedDateTimeString = TypeFormatters.ToString(ImportValidUntil.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SecurityInsightsFileImportData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsFileImportData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SecurityInsightsFileImportData)} does not support writing '{options.Format}' format.");
            }
        }

        SecurityInsightsFileImportData IPersistableModel<SecurityInsightsFileImportData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityInsightsFileImportData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSecurityInsightsFileImportData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SecurityInsightsFileImportData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SecurityInsightsFileImportData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
