// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A Class representing a SecurityInsightsEntity along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SecurityInsightsEntityResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSecurityInsightsEntityResource method.
    /// Otherwise you can get one from its parent resource <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/> using the GetSecurityInsightsEntity method.
    /// </summary>
    public partial class SecurityInsightsEntityResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SecurityInsightsEntityResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="workspaceName"> The workspaceName. </param>
        /// <param name="entityId"> The entityId. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string workspaceName, string entityId)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _securityInsightsEntityEntitiesClientDiagnostics;
        private readonly EntitiesRestOperations _securityInsightsEntityEntitiesRestClient;
        private readonly ClientDiagnostics _entitiesGetTimelineClientDiagnostics;
        private readonly EntitiesGetTimelineRestOperations _entitiesGetTimelineRestClient;
        private readonly SecurityInsightsEntity _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.SecurityInsights/entities";

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsEntityResource"/> class for mocking. </summary>
        protected SecurityInsightsEntityResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsEntityResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SecurityInsightsEntityResource(ArmClient client, SecurityInsightsEntity data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsEntityResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SecurityInsightsEntityResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsEntityEntitiesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string securityInsightsEntityEntitiesApiVersion);
            _securityInsightsEntityEntitiesRestClient = new EntitiesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsEntityEntitiesApiVersion);
            _entitiesGetTimelineClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _entitiesGetTimelineRestClient = new EntitiesGetTimelineRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SecurityInsightsEntity Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets a collection of SecurityInsightsEntityRelationResources in the SecurityInsightsEntity. </summary>
        /// <returns> An object representing collection of SecurityInsightsEntityRelationResources and their operations over a SecurityInsightsEntityRelationResource. </returns>
        public virtual SecurityInsightsEntityRelationCollection GetSecurityInsightsEntityRelations()
        {
            return GetCachedClient(client => new SecurityInsightsEntityRelationCollection(client, Id));
        }

        /// <summary>
        /// Gets an entity relation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}/relations/{relationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityRelations_GetRelation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationName"> Relation Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="relationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="relationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<SecurityInsightsEntityRelationResource>> GetSecurityInsightsEntityRelationAsync(string relationName, CancellationToken cancellationToken = default)
        {
            return await GetSecurityInsightsEntityRelations().GetAsync(relationName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets an entity relation.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}/relations/{relationName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityRelations_GetRelation</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityRelationResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="relationName"> Relation Name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="relationName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="relationName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<SecurityInsightsEntityRelationResource> GetSecurityInsightsEntityRelation(string relationName, CancellationToken cancellationToken = default)
        {
            return GetSecurityInsightsEntityRelations().Get(relationName, cancellationToken);
        }

        /// <summary>
        /// Gets an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SecurityInsightsEntityResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityResource.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityEntitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SecurityInsightsEntityResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityResource.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityEntitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Triggers playbook on a specific entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityIdentifier}/runPlaybook</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_RunPlaybook</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Describes the request body for triggering a playbook on an entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response> RunPlaybookAsync(EntityManualTriggerRequestContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityResource.RunPlaybook");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityEntitiesRestClient.RunPlaybookAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Triggers playbook on a specific entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityIdentifier}/runPlaybook</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_RunPlaybook</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> Describes the request body for triggering a playbook on an entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response RunPlaybook(EntityManualTriggerRequestContent content = null, CancellationToken cancellationToken = default)
        {
            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityResource.RunPlaybook");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityEntitiesRestClient.RunPlaybook(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Expands an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}/expand</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Expand</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The parameters required to execute an expand operation on the given entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<Response<EntityExpandResult>> ExpandAsync(EntityExpandContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityResource.Expand");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityEntitiesRestClient.ExpandAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, content, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Expands an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}/expand</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Expand</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The parameters required to execute an expand operation on the given entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual Response<EntityExpandResult> Expand(EntityExpandContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityResource.Expand");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityEntitiesRestClient.Expand(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, content, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get Insights and Activities for an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}/queries</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Queries</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="kind"> The Kind parameter for queries. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="EntityQueryItem"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<EntityQueryItem> QueriesAsync(EntityItemQueryKind kind, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsEntityEntitiesRestClient.CreateQueriesRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, kind);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => EntityQueryItem.DeserializeEntityQueryItem(e), _securityInsightsEntityEntitiesClientDiagnostics, Pipeline, "SecurityInsightsEntityResource.Queries", "value", null, cancellationToken);
        }

        /// <summary>
        /// Get Insights and Activities for an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}/queries</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Queries</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="kind"> The Kind parameter for queries. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="EntityQueryItem"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<EntityQueryItem> Queries(EntityItemQueryKind kind, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsEntityEntitiesRestClient.CreateQueriesRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, kind);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => EntityQueryItem.DeserializeEntityQueryItem(e), _securityInsightsEntityEntitiesClientDiagnostics, Pipeline, "SecurityInsightsEntityResource.Queries", "value", null, cancellationToken);
        }

        /// <summary>
        /// Execute Insights for an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}/getInsights</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_GetInsights</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The parameters required to execute insights on the given entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <returns> An async collection of <see cref="EntityInsightItem"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<EntityInsightItem> GetInsightsAsync(EntityGetInsightsContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsEntityEntitiesRestClient.CreateGetInsightsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, content);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => EntityInsightItem.DeserializeEntityInsightItem(e), _securityInsightsEntityEntitiesClientDiagnostics, Pipeline, "SecurityInsightsEntityResource.GetInsights", "value", null, cancellationToken);
        }

        /// <summary>
        /// Execute Insights for an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}/getInsights</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_GetInsights</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The parameters required to execute insights on the given entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <returns> A collection of <see cref="EntityInsightItem"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<EntityInsightItem> GetInsights(EntityGetInsightsContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsEntityEntitiesRestClient.CreateGetInsightsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, content);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => EntityInsightItem.DeserializeEntityInsightItem(e), _securityInsightsEntityEntitiesClientDiagnostics, Pipeline, "SecurityInsightsEntityResource.GetInsights", "value", null, cancellationToken);
        }

        /// <summary>
        /// Timeline for an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}/getTimeline</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntitiesGetTimeline_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The parameters required to execute an timeline operation on the given entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <returns> An async collection of <see cref="EntityTimelineItem"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<EntityTimelineItem> GetEntitiesGetTimelinesAsync(EntityTimelineContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _entitiesGetTimelineRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, content);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, null, e => EntityTimelineItem.DeserializeEntityTimelineItem(e), _entitiesGetTimelineClientDiagnostics, Pipeline, "SecurityInsightsEntityResource.GetEntitiesGetTimelines", "value", null, cancellationToken);
        }

        /// <summary>
        /// Timeline for an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}/getTimeline</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntitiesGetTimeline_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="content"> The parameters required to execute an timeline operation on the given entity. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        /// <returns> A collection of <see cref="EntityTimelineItem"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<EntityTimelineItem> GetEntitiesGetTimelines(EntityTimelineContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            HttpMessage FirstPageRequest(int? pageSizeHint) => _entitiesGetTimelineRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, content);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, null, e => EntityTimelineItem.DeserializeEntityTimelineItem(e), _entitiesGetTimelineClientDiagnostics, Pipeline, "SecurityInsightsEntityResource.GetEntitiesGetTimelines", "value", null, cancellationToken);
        }
    }
}
