// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsEntityQueryTemplateResource"/> and their operations.
    /// Each <see cref="SecurityInsightsEntityQueryTemplateResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="SecurityInsightsEntityQueryTemplateCollection"/> instance call the GetSecurityInsightsEntityQueryTemplates method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class SecurityInsightsEntityQueryTemplateCollection : ArmCollection, IEnumerable<SecurityInsightsEntityQueryTemplateResource>, IAsyncEnumerable<SecurityInsightsEntityQueryTemplateResource>
    {
        private readonly ClientDiagnostics _securityInsightsEntityQueryTemplateEntityQueryTemplatesClientDiagnostics;
        private readonly EntityQueryTemplatesRestOperations _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsEntityQueryTemplateCollection"/> class for mocking. </summary>
        protected SecurityInsightsEntityQueryTemplateCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsEntityQueryTemplateCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsEntityQueryTemplateCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsEntityQueryTemplateEntityQueryTemplatesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsEntityQueryTemplateResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsEntityQueryTemplateResource.ResourceType, out string securityInsightsEntityQueryTemplateEntityQueryTemplatesApiVersion);
            _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient = new EntityQueryTemplatesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsEntityQueryTemplateEntityQueryTemplatesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets an entity query.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueryTemplates/{entityQueryTemplateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueryTemplates_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryTemplateId"> entity query template ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryTemplateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryTemplateId"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsEntityQueryTemplateResource>> GetAsync(string entityQueryTemplateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryTemplateId, nameof(entityQueryTemplateId));

            using var scope = _securityInsightsEntityQueryTemplateEntityQueryTemplatesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryTemplateCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryTemplateId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityQueryTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an entity query.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueryTemplates/{entityQueryTemplateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueryTemplates_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryTemplateId"> entity query template ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryTemplateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryTemplateId"/> is null. </exception>
        public virtual Response<SecurityInsightsEntityQueryTemplateResource> Get(string entityQueryTemplateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryTemplateId, nameof(entityQueryTemplateId));

            using var scope = _securityInsightsEntityQueryTemplateEntityQueryTemplatesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryTemplateCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryTemplateId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityQueryTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all entity query templates.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueryTemplates</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueryTemplates_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="kind"> The entity template query kind we want to fetch. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsEntityQueryTemplateResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsEntityQueryTemplateResource> GetAllAsync(EntityTemplateQueryKind? kind = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, kind);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, kind);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsEntityQueryTemplateResource(Client, SecurityInsightsEntityQueryTemplateData.DeserializeSecurityInsightsEntityQueryTemplateData(e)), _securityInsightsEntityQueryTemplateEntityQueryTemplatesClientDiagnostics, Pipeline, "SecurityInsightsEntityQueryTemplateCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all entity query templates.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueryTemplates</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueryTemplates_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="kind"> The entity template query kind we want to fetch. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsEntityQueryTemplateResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsEntityQueryTemplateResource> GetAll(EntityTemplateQueryKind? kind = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, kind);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, kind);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsEntityQueryTemplateResource(Client, SecurityInsightsEntityQueryTemplateData.DeserializeSecurityInsightsEntityQueryTemplateData(e)), _securityInsightsEntityQueryTemplateEntityQueryTemplatesClientDiagnostics, Pipeline, "SecurityInsightsEntityQueryTemplateCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueryTemplates/{entityQueryTemplateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueryTemplates_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryTemplateId"> entity query template ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryTemplateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryTemplateId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string entityQueryTemplateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryTemplateId, nameof(entityQueryTemplateId));

            using var scope = _securityInsightsEntityQueryTemplateEntityQueryTemplatesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryTemplateCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryTemplateId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueryTemplates/{entityQueryTemplateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueryTemplates_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryTemplateId"> entity query template ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryTemplateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryTemplateId"/> is null. </exception>
        public virtual Response<bool> Exists(string entityQueryTemplateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryTemplateId, nameof(entityQueryTemplateId));

            using var scope = _securityInsightsEntityQueryTemplateEntityQueryTemplatesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryTemplateCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryTemplateId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueryTemplates/{entityQueryTemplateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueryTemplates_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryTemplateId"> entity query template ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryTemplateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryTemplateId"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsEntityQueryTemplateResource>> GetIfExistsAsync(string entityQueryTemplateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryTemplateId, nameof(entityQueryTemplateId));

            using var scope = _securityInsightsEntityQueryTemplateEntityQueryTemplatesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryTemplateCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryTemplateId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsEntityQueryTemplateResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityQueryTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueryTemplates/{entityQueryTemplateId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueryTemplates_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryTemplateResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryTemplateId"> entity query template ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryTemplateId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryTemplateId"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsEntityQueryTemplateResource> GetIfExists(string entityQueryTemplateId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryTemplateId, nameof(entityQueryTemplateId));

            using var scope = _securityInsightsEntityQueryTemplateEntityQueryTemplatesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryTemplateCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityQueryTemplateEntityQueryTemplatesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryTemplateId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsEntityQueryTemplateResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityQueryTemplateResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsEntityQueryTemplateResource> IEnumerable<SecurityInsightsEntityQueryTemplateResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsEntityQueryTemplateResource> IAsyncEnumerable<SecurityInsightsEntityQueryTemplateResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
