// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsEntityQueryResource"/> and their operations.
    /// Each <see cref="SecurityInsightsEntityQueryResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="SecurityInsightsEntityQueryCollection"/> instance call the GetSecurityInsightsEntityQueries method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class SecurityInsightsEntityQueryCollection : ArmCollection, IEnumerable<SecurityInsightsEntityQueryResource>, IAsyncEnumerable<SecurityInsightsEntityQueryResource>
    {
        private readonly ClientDiagnostics _securityInsightsEntityQueryEntityQueriesClientDiagnostics;
        private readonly EntityQueriesRestOperations _securityInsightsEntityQueryEntityQueriesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsEntityQueryCollection"/> class for mocking. </summary>
        protected SecurityInsightsEntityQueryCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsEntityQueryCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsEntityQueryCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsEntityQueryEntityQueriesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsEntityQueryResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsEntityQueryResource.ResourceType, out string securityInsightsEntityQueryEntityQueriesApiVersion);
            _securityInsightsEntityQueryEntityQueriesRestClient = new EntityQueriesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsEntityQueryEntityQueriesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates the entity query.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries/{entityQueryId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueries_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="entityQueryId"> entity query ID. </param>
        /// <param name="content"> The entity query we want to create or update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryId"/> or <paramref name="content"/> is null. </exception>
        public virtual async Task<ArmOperation<SecurityInsightsEntityQueryResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string entityQueryId, SecurityInsightsEntityQueryCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryId, nameof(entityQueryId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _securityInsightsEntityQueryEntityQueriesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityQueryEntityQueriesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryId, content, cancellationToken).ConfigureAwait(false);
                var uri = _securityInsightsEntityQueryEntityQueriesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryId, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsEntityQueryResource>(Response.FromValue(new SecurityInsightsEntityQueryResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates the entity query.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries/{entityQueryId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueries_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="entityQueryId"> entity query ID. </param>
        /// <param name="content"> The entity query we want to create or update. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryId"/> or <paramref name="content"/> is null. </exception>
        public virtual ArmOperation<SecurityInsightsEntityQueryResource> CreateOrUpdate(WaitUntil waitUntil, string entityQueryId, SecurityInsightsEntityQueryCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryId, nameof(entityQueryId));
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _securityInsightsEntityQueryEntityQueriesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityQueryEntityQueriesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryId, content, cancellationToken);
                var uri = _securityInsightsEntityQueryEntityQueriesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryId, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsEntityQueryResource>(Response.FromValue(new SecurityInsightsEntityQueryResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an entity query.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries/{entityQueryId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryId"> entity query ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryId"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsEntityQueryResource>> GetAsync(string entityQueryId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryId, nameof(entityQueryId));

            using var scope = _securityInsightsEntityQueryEntityQueriesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityQueryEntityQueriesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityQueryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an entity query.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries/{entityQueryId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryId"> entity query ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryId"/> is null. </exception>
        public virtual Response<SecurityInsightsEntityQueryResource> Get(string entityQueryId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryId, nameof(entityQueryId));

            using var scope = _securityInsightsEntityQueryEntityQueriesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityQueryEntityQueriesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityQueryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all entity queries.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueries_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="kind"> The entity query kind we want to fetch. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsEntityQueryResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsEntityQueryResource> GetAllAsync(EntityQueryKind? kind = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsEntityQueryEntityQueriesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, kind);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsEntityQueryEntityQueriesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, kind);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsEntityQueryResource(Client, SecurityInsightsEntityQueryData.DeserializeSecurityInsightsEntityQueryData(e)), _securityInsightsEntityQueryEntityQueriesClientDiagnostics, Pipeline, "SecurityInsightsEntityQueryCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all entity queries.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueries_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="kind"> The entity query kind we want to fetch. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsEntityQueryResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsEntityQueryResource> GetAll(EntityQueryKind? kind = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsEntityQueryEntityQueriesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, kind);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsEntityQueryEntityQueriesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name, kind);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsEntityQueryResource(Client, SecurityInsightsEntityQueryData.DeserializeSecurityInsightsEntityQueryData(e)), _securityInsightsEntityQueryEntityQueriesClientDiagnostics, Pipeline, "SecurityInsightsEntityQueryCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries/{entityQueryId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryId"> entity query ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string entityQueryId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryId, nameof(entityQueryId));

            using var scope = _securityInsightsEntityQueryEntityQueriesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityQueryEntityQueriesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries/{entityQueryId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryId"> entity query ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryId"/> is null. </exception>
        public virtual Response<bool> Exists(string entityQueryId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryId, nameof(entityQueryId));

            using var scope = _securityInsightsEntityQueryEntityQueriesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityQueryEntityQueriesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries/{entityQueryId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryId"> entity query ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryId"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsEntityQueryResource>> GetIfExistsAsync(string entityQueryId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryId, nameof(entityQueryId));

            using var scope = _securityInsightsEntityQueryEntityQueriesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityQueryEntityQueriesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsEntityQueryResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityQueryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entityQueries/{entityQueryId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>EntityQueries_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityQueryResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityQueryId"> entity query ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityQueryId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityQueryId"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsEntityQueryResource> GetIfExists(string entityQueryId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityQueryId, nameof(entityQueryId));

            using var scope = _securityInsightsEntityQueryEntityQueriesClientDiagnostics.CreateScope("SecurityInsightsEntityQueryCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityQueryEntityQueriesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityQueryId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsEntityQueryResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityQueryResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsEntityQueryResource> IEnumerable<SecurityInsightsEntityQueryResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsEntityQueryResource> IAsyncEnumerable<SecurityInsightsEntityQueryResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
