// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.SecurityInsights.Models;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsEntityResource"/> and their operations.
    /// Each <see cref="SecurityInsightsEntityResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="SecurityInsightsEntityCollection"/> instance call the GetSecurityInsightsEntities method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class SecurityInsightsEntityCollection : ArmCollection, IEnumerable<SecurityInsightsEntityResource>, IAsyncEnumerable<SecurityInsightsEntityResource>
    {
        private readonly ClientDiagnostics _securityInsightsEntityEntitiesClientDiagnostics;
        private readonly EntitiesRestOperations _securityInsightsEntityEntitiesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsEntityCollection"/> class for mocking. </summary>
        protected SecurityInsightsEntityCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsEntityCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsEntityCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsEntityEntitiesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsEntityResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsEntityResource.ResourceType, out string securityInsightsEntityEntitiesApiVersion);
            _securityInsightsEntityEntitiesRestClient = new EntitiesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsEntityEntitiesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityId"> entity ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityId"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsEntityResource>> GetAsync(string entityId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityId, nameof(entityId));

            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityEntitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an entity.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityId"> entity ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityId"/> is null. </exception>
        public virtual Response<SecurityInsightsEntityResource> Get(string entityId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityId, nameof(entityId));

            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityEntitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all entities.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsEntityResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsEntityResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsEntityEntitiesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsEntityEntitiesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsEntityResource(Client, SecurityInsightsEntity.DeserializeSecurityInsightsEntity(e)), _securityInsightsEntityEntitiesClientDiagnostics, Pipeline, "SecurityInsightsEntityCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all entities.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsEntityResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsEntityResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsEntityEntitiesRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsEntityEntitiesRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsEntityResource(Client, SecurityInsightsEntity.DeserializeSecurityInsightsEntity(e)), _securityInsightsEntityEntitiesClientDiagnostics, Pipeline, "SecurityInsightsEntityCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityId"> entity ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string entityId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityId, nameof(entityId));

            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityEntitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityId"> entity ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityId"/> is null. </exception>
        public virtual Response<bool> Exists(string entityId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityId, nameof(entityId));

            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityEntitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityId"> entity ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityId"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsEntityResource>> GetIfExistsAsync(string entityId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityId, nameof(entityId));

            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsEntityEntitiesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsEntityResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/entities/{entityId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Entities_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsEntityResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="entityId"> entity ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="entityId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="entityId"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsEntityResource> GetIfExists(string entityId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(entityId, nameof(entityId));

            using var scope = _securityInsightsEntityEntitiesClientDiagnostics.CreateScope("SecurityInsightsEntityCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsEntityEntitiesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, entityId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsEntityResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsEntityResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsEntityResource> IEnumerable<SecurityInsightsEntityResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsEntityResource> IAsyncEnumerable<SecurityInsightsEntityResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
