// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsDataConnectorDefinitionResource"/> and their operations.
    /// Each <see cref="SecurityInsightsDataConnectorDefinitionResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="SecurityInsightsDataConnectorDefinitionCollection"/> instance call the GetSecurityInsightsDataConnectorDefinitions method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class SecurityInsightsDataConnectorDefinitionCollection : ArmCollection, IEnumerable<SecurityInsightsDataConnectorDefinitionResource>, IAsyncEnumerable<SecurityInsightsDataConnectorDefinitionResource>
    {
        private readonly ClientDiagnostics _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics;
        private readonly DataConnectorDefinitionsRestOperations _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsDataConnectorDefinitionCollection"/> class for mocking. </summary>
        protected SecurityInsightsDataConnectorDefinitionCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsDataConnectorDefinitionCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsDataConnectorDefinitionCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsDataConnectorDefinitionResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsDataConnectorDefinitionResource.ResourceType, out string securityInsightsDataConnectorDefinitionDataConnectorDefinitionsApiVersion);
            _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient = new DataConnectorDefinitionsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsDataConnectorDefinitionDataConnectorDefinitionsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates the data connector definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions/{dataConnectorDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataConnectorDefinitions_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsDataConnectorDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="dataConnectorDefinitionName"> The data connector definition name. </param>
        /// <param name="data"> The data connector definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dataConnectorDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dataConnectorDefinitionName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SecurityInsightsDataConnectorDefinitionResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string dataConnectorDefinitionName, SecurityInsightsDataConnectorDefinitionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dataConnectorDefinitionName, nameof(dataConnectorDefinitionName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics.CreateScope("SecurityInsightsDataConnectorDefinitionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dataConnectorDefinitionName, data, cancellationToken).ConfigureAwait(false);
                var uri = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dataConnectorDefinitionName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsDataConnectorDefinitionResource>(Response.FromValue(new SecurityInsightsDataConnectorDefinitionResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates the data connector definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions/{dataConnectorDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataConnectorDefinitions_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsDataConnectorDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="dataConnectorDefinitionName"> The data connector definition name. </param>
        /// <param name="data"> The data connector definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dataConnectorDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dataConnectorDefinitionName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SecurityInsightsDataConnectorDefinitionResource> CreateOrUpdate(WaitUntil waitUntil, string dataConnectorDefinitionName, SecurityInsightsDataConnectorDefinitionData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dataConnectorDefinitionName, nameof(dataConnectorDefinitionName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics.CreateScope("SecurityInsightsDataConnectorDefinitionCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dataConnectorDefinitionName, data, cancellationToken);
                var uri = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dataConnectorDefinitionName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SecurityInsightsArmOperation<SecurityInsightsDataConnectorDefinitionResource>(Response.FromValue(new SecurityInsightsDataConnectorDefinitionResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a data connector definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions/{dataConnectorDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataConnectorDefinitions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsDataConnectorDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataConnectorDefinitionName"> The data connector definition name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dataConnectorDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dataConnectorDefinitionName"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsDataConnectorDefinitionResource>> GetAsync(string dataConnectorDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dataConnectorDefinitionName, nameof(dataConnectorDefinitionName));

            using var scope = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics.CreateScope("SecurityInsightsDataConnectorDefinitionCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dataConnectorDefinitionName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsDataConnectorDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a data connector definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions/{dataConnectorDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataConnectorDefinitions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsDataConnectorDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataConnectorDefinitionName"> The data connector definition name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dataConnectorDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dataConnectorDefinitionName"/> is null. </exception>
        public virtual Response<SecurityInsightsDataConnectorDefinitionResource> Get(string dataConnectorDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dataConnectorDefinitionName, nameof(dataConnectorDefinitionName));

            using var scope = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics.CreateScope("SecurityInsightsDataConnectorDefinitionCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dataConnectorDefinitionName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsDataConnectorDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all data connector definitions.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataConnectorDefinitions_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsDataConnectorDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsDataConnectorDefinitionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsDataConnectorDefinitionResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsDataConnectorDefinitionResource(Client, SecurityInsightsDataConnectorDefinitionData.DeserializeSecurityInsightsDataConnectorDefinitionData(e)), _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics, Pipeline, "SecurityInsightsDataConnectorDefinitionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all data connector definitions.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataConnectorDefinitions_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsDataConnectorDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsDataConnectorDefinitionResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsDataConnectorDefinitionResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsDataConnectorDefinitionResource(Client, SecurityInsightsDataConnectorDefinitionData.DeserializeSecurityInsightsDataConnectorDefinitionData(e)), _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics, Pipeline, "SecurityInsightsDataConnectorDefinitionCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions/{dataConnectorDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataConnectorDefinitions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsDataConnectorDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataConnectorDefinitionName"> The data connector definition name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dataConnectorDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dataConnectorDefinitionName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string dataConnectorDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dataConnectorDefinitionName, nameof(dataConnectorDefinitionName));

            using var scope = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics.CreateScope("SecurityInsightsDataConnectorDefinitionCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dataConnectorDefinitionName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions/{dataConnectorDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataConnectorDefinitions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsDataConnectorDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataConnectorDefinitionName"> The data connector definition name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dataConnectorDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dataConnectorDefinitionName"/> is null. </exception>
        public virtual Response<bool> Exists(string dataConnectorDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dataConnectorDefinitionName, nameof(dataConnectorDefinitionName));

            using var scope = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics.CreateScope("SecurityInsightsDataConnectorDefinitionCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dataConnectorDefinitionName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions/{dataConnectorDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataConnectorDefinitions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsDataConnectorDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataConnectorDefinitionName"> The data connector definition name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dataConnectorDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dataConnectorDefinitionName"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsDataConnectorDefinitionResource>> GetIfExistsAsync(string dataConnectorDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dataConnectorDefinitionName, nameof(dataConnectorDefinitionName));

            using var scope = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics.CreateScope("SecurityInsightsDataConnectorDefinitionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dataConnectorDefinitionName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsDataConnectorDefinitionResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsDataConnectorDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/dataConnectorDefinitions/{dataConnectorDefinitionName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DataConnectorDefinitions_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsDataConnectorDefinitionResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="dataConnectorDefinitionName"> The data connector definition name. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="dataConnectorDefinitionName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="dataConnectorDefinitionName"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsDataConnectorDefinitionResource> GetIfExists(string dataConnectorDefinitionName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(dataConnectorDefinitionName, nameof(dataConnectorDefinitionName));

            using var scope = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsClientDiagnostics.CreateScope("SecurityInsightsDataConnectorDefinitionCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsDataConnectorDefinitionDataConnectorDefinitionsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, dataConnectorDefinitionName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsDataConnectorDefinitionResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsDataConnectorDefinitionResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsDataConnectorDefinitionResource> IEnumerable<SecurityInsightsDataConnectorDefinitionResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsDataConnectorDefinitionResource> IAsyncEnumerable<SecurityInsightsDataConnectorDefinitionResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
