// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.SecurityInsights
{
    /// <summary>
    /// A class representing a collection of <see cref="SecurityInsightsBillingStatisticResource"/> and their operations.
    /// Each <see cref="SecurityInsightsBillingStatisticResource"/> in the collection will belong to the same instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// To get a <see cref="SecurityInsightsBillingStatisticCollection"/> instance call the GetSecurityInsightsBillingStatistics method from an instance of <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/>.
    /// </summary>
    public partial class SecurityInsightsBillingStatisticCollection : ArmCollection, IEnumerable<SecurityInsightsBillingStatisticResource>, IAsyncEnumerable<SecurityInsightsBillingStatisticResource>
    {
        private readonly ClientDiagnostics _securityInsightsBillingStatisticBillingStatisticsClientDiagnostics;
        private readonly BillingStatisticsRestOperations _securityInsightsBillingStatisticBillingStatisticsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsBillingStatisticCollection"/> class for mocking. </summary>
        protected SecurityInsightsBillingStatisticCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SecurityInsightsBillingStatisticCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SecurityInsightsBillingStatisticCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _securityInsightsBillingStatisticBillingStatisticsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.SecurityInsights", SecurityInsightsBillingStatisticResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SecurityInsightsBillingStatisticResource.ResourceType, out string securityInsightsBillingStatisticBillingStatisticsApiVersion);
            _securityInsightsBillingStatisticBillingStatisticsRestClient = new BillingStatisticsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, securityInsightsBillingStatisticBillingStatisticsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, OperationalInsightsWorkspaceSecurityInsightsResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a billing statistic
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/billingStatistics/{billingStatisticName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsBillingStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingStatisticName"> The name of the billing statistic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingStatisticName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingStatisticName"/> is null. </exception>
        public virtual async Task<Response<SecurityInsightsBillingStatisticResource>> GetAsync(string billingStatisticName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingStatisticName, nameof(billingStatisticName));

            using var scope = _securityInsightsBillingStatisticBillingStatisticsClientDiagnostics.CreateScope("SecurityInsightsBillingStatisticCollection.Get");
            scope.Start();
            try
            {
                var response = await _securityInsightsBillingStatisticBillingStatisticsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, billingStatisticName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsBillingStatisticResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a billing statistic
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/billingStatistics/{billingStatisticName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsBillingStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingStatisticName"> The name of the billing statistic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingStatisticName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingStatisticName"/> is null. </exception>
        public virtual Response<SecurityInsightsBillingStatisticResource> Get(string billingStatisticName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingStatisticName, nameof(billingStatisticName));

            using var scope = _securityInsightsBillingStatisticBillingStatisticsClientDiagnostics.CreateScope("SecurityInsightsBillingStatisticCollection.Get");
            scope.Start();
            try
            {
                var response = _securityInsightsBillingStatisticBillingStatisticsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, billingStatisticName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsBillingStatisticResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets all Microsoft Sentinel billing statistics.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/billingStatistics</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingStatistics_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsBillingStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SecurityInsightsBillingStatisticResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SecurityInsightsBillingStatisticResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsBillingStatisticBillingStatisticsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsBillingStatisticBillingStatisticsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsBillingStatisticResource(Client, SecurityInsightsBillingStatisticData.DeserializeSecurityInsightsBillingStatisticData(e)), _securityInsightsBillingStatisticBillingStatisticsClientDiagnostics, Pipeline, "SecurityInsightsBillingStatisticCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets all Microsoft Sentinel billing statistics.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/billingStatistics</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingStatistics_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsBillingStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SecurityInsightsBillingStatisticResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SecurityInsightsBillingStatisticResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _securityInsightsBillingStatisticBillingStatisticsRestClient.CreateListRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _securityInsightsBillingStatisticBillingStatisticsRestClient.CreateListNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SecurityInsightsBillingStatisticResource(Client, SecurityInsightsBillingStatisticData.DeserializeSecurityInsightsBillingStatisticData(e)), _securityInsightsBillingStatisticBillingStatisticsClientDiagnostics, Pipeline, "SecurityInsightsBillingStatisticCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/billingStatistics/{billingStatisticName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsBillingStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingStatisticName"> The name of the billing statistic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingStatisticName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingStatisticName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string billingStatisticName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingStatisticName, nameof(billingStatisticName));

            using var scope = _securityInsightsBillingStatisticBillingStatisticsClientDiagnostics.CreateScope("SecurityInsightsBillingStatisticCollection.Exists");
            scope.Start();
            try
            {
                var response = await _securityInsightsBillingStatisticBillingStatisticsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, billingStatisticName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/billingStatistics/{billingStatisticName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsBillingStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingStatisticName"> The name of the billing statistic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingStatisticName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingStatisticName"/> is null. </exception>
        public virtual Response<bool> Exists(string billingStatisticName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingStatisticName, nameof(billingStatisticName));

            using var scope = _securityInsightsBillingStatisticBillingStatisticsClientDiagnostics.CreateScope("SecurityInsightsBillingStatisticCollection.Exists");
            scope.Start();
            try
            {
                var response = _securityInsightsBillingStatisticBillingStatisticsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, billingStatisticName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/billingStatistics/{billingStatisticName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsBillingStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingStatisticName"> The name of the billing statistic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingStatisticName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingStatisticName"/> is null. </exception>
        public virtual async Task<NullableResponse<SecurityInsightsBillingStatisticResource>> GetIfExistsAsync(string billingStatisticName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingStatisticName, nameof(billingStatisticName));

            using var scope = _securityInsightsBillingStatisticBillingStatisticsClientDiagnostics.CreateScope("SecurityInsightsBillingStatisticCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _securityInsightsBillingStatisticBillingStatisticsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, billingStatisticName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsBillingStatisticResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsBillingStatisticResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.OperationalInsights/workspaces/{workspaceName}/providers/Microsoft.SecurityInsights/billingStatistics/{billingStatisticName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>BillingStatistics_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-01-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SecurityInsightsBillingStatisticResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="billingStatisticName"> The name of the billing statistic. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="billingStatisticName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="billingStatisticName"/> is null. </exception>
        public virtual NullableResponse<SecurityInsightsBillingStatisticResource> GetIfExists(string billingStatisticName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(billingStatisticName, nameof(billingStatisticName));

            using var scope = _securityInsightsBillingStatisticBillingStatisticsClientDiagnostics.CreateScope("SecurityInsightsBillingStatisticCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _securityInsightsBillingStatisticBillingStatisticsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, billingStatisticName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SecurityInsightsBillingStatisticResource>(response.GetRawResponse());
                return Response.FromValue(new SecurityInsightsBillingStatisticResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SecurityInsightsBillingStatisticResource> IEnumerable<SecurityInsightsBillingStatisticResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SecurityInsightsBillingStatisticResource> IAsyncEnumerable<SecurityInsightsBillingStatisticResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
