// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The current mode of the workspace manager configuration. </summary>
    public readonly partial struct WorkspaceManagerConfigurationMode : IEquatable<WorkspaceManagerConfigurationMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WorkspaceManagerConfigurationMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WorkspaceManagerConfigurationMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> The workspace manager configuration is enabled. </summary>
        public static WorkspaceManagerConfigurationMode Enabled { get; } = new WorkspaceManagerConfigurationMode(EnabledValue);
        /// <summary> The workspace manager configuration is disabled. </summary>
        public static WorkspaceManagerConfigurationMode Disabled { get; } = new WorkspaceManagerConfigurationMode(DisabledValue);
        /// <summary> Determines if two <see cref="WorkspaceManagerConfigurationMode"/> values are the same. </summary>
        public static bool operator ==(WorkspaceManagerConfigurationMode left, WorkspaceManagerConfigurationMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WorkspaceManagerConfigurationMode"/> values are not the same. </summary>
        public static bool operator !=(WorkspaceManagerConfigurationMode left, WorkspaceManagerConfigurationMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WorkspaceManagerConfigurationMode"/>. </summary>
        public static implicit operator WorkspaceManagerConfigurationMode(string value) => new WorkspaceManagerConfigurationMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WorkspaceManagerConfigurationMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WorkspaceManagerConfigurationMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
