// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The sourceType of the watchlist. </summary>
    public readonly partial struct WatchlistSourceType : IEquatable<WatchlistSourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="WatchlistSourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public WatchlistSourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LocalFileValue = "Local file";
        private const string RemoteStorageValue = "Remote storage";

        /// <summary> Local file. </summary>
        public static WatchlistSourceType LocalFile { get; } = new WatchlistSourceType(LocalFileValue);
        /// <summary> Remote storage. </summary>
        public static WatchlistSourceType RemoteStorage { get; } = new WatchlistSourceType(RemoteStorageValue);
        /// <summary> Determines if two <see cref="WatchlistSourceType"/> values are the same. </summary>
        public static bool operator ==(WatchlistSourceType left, WatchlistSourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="WatchlistSourceType"/> values are not the same. </summary>
        public static bool operator !=(WatchlistSourceType left, WatchlistSourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="WatchlistSourceType"/>. </summary>
        public static implicit operator WatchlistSourceType(string value) => new WatchlistSourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is WatchlistSourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(WatchlistSourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
