// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Settings with single toggle. </summary>
    public partial class UebaSettings : SecurityInsightsSettingData
    {
        /// <summary> Initializes a new instance of <see cref="UebaSettings"/>. </summary>
        public UebaSettings()
        {
            DataSources = new ChangeTrackingList<UebaDataSource>();
            Kind = SettingKind.Ueba;
        }

        /// <summary> Initializes a new instance of <see cref="UebaSettings"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The kind of the setting. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="dataSources"> The relevant data sources that enriched by ueba. </param>
        internal UebaSettings(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, SettingKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<UebaDataSource> dataSources) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            DataSources = dataSources;
            Kind = kind;
        }

        /// <summary> The relevant data sources that enriched by ueba. </summary>
        [WirePath("properties.dataSources")]
        public IList<UebaDataSource> DataSources { get; }
    }
}
