// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The data source that enriched by ueba. </summary>
    public readonly partial struct UebaDataSource : IEquatable<UebaDataSource>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UebaDataSource"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UebaDataSource(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AuditLogsValue = "AuditLogs";
        private const string AzureActivityValue = "AzureActivity";
        private const string SecurityEventValue = "SecurityEvent";
        private const string SigninLogsValue = "SigninLogs";

        /// <summary> AuditLogs. </summary>
        public static UebaDataSource AuditLogs { get; } = new UebaDataSource(AuditLogsValue);
        /// <summary> AzureActivity. </summary>
        public static UebaDataSource AzureActivity { get; } = new UebaDataSource(AzureActivityValue);
        /// <summary> SecurityEvent. </summary>
        public static UebaDataSource SecurityEvent { get; } = new UebaDataSource(SecurityEventValue);
        /// <summary> SigninLogs. </summary>
        public static UebaDataSource SigninLogs { get; } = new UebaDataSource(SigninLogsValue);
        /// <summary> Determines if two <see cref="UebaDataSource"/> values are the same. </summary>
        public static bool operator ==(UebaDataSource left, UebaDataSource right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UebaDataSource"/> values are not the same. </summary>
        public static bool operator !=(UebaDataSource left, UebaDataSource right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UebaDataSource"/>. </summary>
        public static implicit operator UebaDataSource(string value) => new UebaDataSource(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UebaDataSource other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UebaDataSource other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
