// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The TriggersWhen. </summary>
    public readonly partial struct TriggersWhen : IEquatable<TriggersWhen>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TriggersWhen"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TriggersWhen(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatedValue = "Created";
        private const string UpdatedValue = "Updated";

        /// <summary> Trigger on created objects. </summary>
        public static TriggersWhen Created { get; } = new TriggersWhen(CreatedValue);
        /// <summary> Trigger on updated objects. </summary>
        public static TriggersWhen Updated { get; } = new TriggersWhen(UpdatedValue);
        /// <summary> Determines if two <see cref="TriggersWhen"/> values are the same. </summary>
        public static bool operator ==(TriggersWhen left, TriggersWhen right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TriggersWhen"/> values are not the same. </summary>
        public static bool operator !=(TriggersWhen left, TriggersWhen right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TriggersWhen"/>. </summary>
        public static implicit operator TriggersWhen(string value) => new TriggersWhen(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TriggersWhen other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TriggersWhen other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
