// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The TriggersOn. </summary>
    public readonly partial struct TriggersOn : IEquatable<TriggersOn>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TriggersOn"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TriggersOn(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IncidentsValue = "Incidents";
        private const string AlertsValue = "Alerts";

        /// <summary> Trigger on Incidents. </summary>
        public static TriggersOn Incidents { get; } = new TriggersOn(IncidentsValue);
        /// <summary> Trigger on Alerts. </summary>
        public static TriggersOn Alerts { get; } = new TriggersOn(AlertsValue);
        /// <summary> Determines if two <see cref="TriggersOn"/> values are the same. </summary>
        public static bool operator ==(TriggersOn left, TriggersOn right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TriggersOn"/> values are not the same. </summary>
        public static bool operator !=(TriggersOn left, TriggersOn right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TriggersOn"/>. </summary>
        public static implicit operator TriggersOn(string value) => new TriggersOn(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TriggersOn other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TriggersOn other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
