// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The triggered analytics rule run provisioning state. </summary>
    public readonly partial struct TriggeredAnalyticsRuleRunProvisioningState : IEquatable<TriggeredAnalyticsRuleRunProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TriggeredAnalyticsRuleRunProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TriggeredAnalyticsRuleRunProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AcceptedValue = "Accepted";
        private const string InProgressValue = "InProgress";
        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string CanceledValue = "Canceled";

        /// <summary> Accepted. </summary>
        public static TriggeredAnalyticsRuleRunProvisioningState Accepted { get; } = new TriggeredAnalyticsRuleRunProvisioningState(AcceptedValue);
        /// <summary> InProgress. </summary>
        public static TriggeredAnalyticsRuleRunProvisioningState InProgress { get; } = new TriggeredAnalyticsRuleRunProvisioningState(InProgressValue);
        /// <summary> Succeeded. </summary>
        public static TriggeredAnalyticsRuleRunProvisioningState Succeeded { get; } = new TriggeredAnalyticsRuleRunProvisioningState(SucceededValue);
        /// <summary> Failed. </summary>
        public static TriggeredAnalyticsRuleRunProvisioningState Failed { get; } = new TriggeredAnalyticsRuleRunProvisioningState(FailedValue);
        /// <summary> Canceled. </summary>
        public static TriggeredAnalyticsRuleRunProvisioningState Canceled { get; } = new TriggeredAnalyticsRuleRunProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="TriggeredAnalyticsRuleRunProvisioningState"/> values are the same. </summary>
        public static bool operator ==(TriggeredAnalyticsRuleRunProvisioningState left, TriggeredAnalyticsRuleRunProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TriggeredAnalyticsRuleRunProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(TriggeredAnalyticsRuleRunProvisioningState left, TriggeredAnalyticsRuleRunProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TriggeredAnalyticsRuleRunProvisioningState"/>. </summary>
        public static implicit operator TriggeredAnalyticsRuleRunProvisioningState(string value) => new TriggeredAnalyticsRuleRunProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TriggeredAnalyticsRuleRunProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TriggeredAnalyticsRuleRunProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
