// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> timeline aggregation information per kind. </summary>
    internal partial class TimelineAggregation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="TimelineAggregation"/>. </summary>
        /// <param name="count"> the total items found for a kind. </param>
        /// <param name="kind"> the query kind. </param>
        internal TimelineAggregation(int count, EntityTimelineKind kind)
        {
            Count = count;
            Kind = kind;
        }

        /// <summary> Initializes a new instance of <see cref="TimelineAggregation"/>. </summary>
        /// <param name="count"> the total items found for a kind. </param>
        /// <param name="kind"> the query kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal TimelineAggregation(int count, EntityTimelineKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Count = count;
            Kind = kind;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="TimelineAggregation"/> for deserialization. </summary>
        internal TimelineAggregation()
        {
        }

        /// <summary> the total items found for a kind. </summary>
        [WirePath("count")]
        public int Count { get; }
        /// <summary> the query kind. </summary>
        [WirePath("kind")]
        public EntityTimelineKind Kind { get; }
    }
}
