// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Data connector to pull Threat intelligence data from TAXII 2.0/2.1 server. </summary>
    public partial class ThreatIntelligenceTaxiiDataConnector : SecurityInsightsDataConnectorData
    {
        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceTaxiiDataConnector"/>. </summary>
        public ThreatIntelligenceTaxiiDataConnector()
        {
            Kind = DataConnectorKind.ThreatIntelligenceTaxii;
        }

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceTaxiiDataConnector"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The data connector kind. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="tenantId"> The tenant id to connect to, and get the data from. </param>
        /// <param name="workspaceId"> The workspace id. </param>
        /// <param name="friendlyName"> The friendly name for the TAXII server. </param>
        /// <param name="taxiiServer"> The API root for the TAXII server. </param>
        /// <param name="collectionId"> The collection id of the TAXII server. </param>
        /// <param name="userName"> The userName for the TAXII server. </param>
        /// <param name="password"> The password for the TAXII server. </param>
        /// <param name="taxiiLookbackPeriod"> The lookback period for the TAXII server. </param>
        /// <param name="pollingFrequency"> The polling frequency for the TAXII server. </param>
        /// <param name="taxiiClient"> Data type for TAXII connector. </param>
        internal ThreatIntelligenceTaxiiDataConnector(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DataConnectorKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, Guid? tenantId, string workspaceId, string friendlyName, string taxiiServer, string collectionId, string userName, string password, DateTimeOffset? taxiiLookbackPeriod, PollingFrequency? pollingFrequency, DataConnectorDataTypeCommon taxiiClient) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            TenantId = tenantId;
            WorkspaceId = workspaceId;
            FriendlyName = friendlyName;
            TaxiiServer = taxiiServer;
            CollectionId = collectionId;
            UserName = userName;
            Password = password;
            TaxiiLookbackPeriod = taxiiLookbackPeriod;
            PollingFrequency = pollingFrequency;
            TaxiiClient = taxiiClient;
            Kind = kind;
        }

        /// <summary> The tenant id to connect to, and get the data from. </summary>
        [WirePath("properties.tenantId")]
        public Guid? TenantId { get; set; }
        /// <summary> The workspace id. </summary>
        [WirePath("properties.workspaceId")]
        public string WorkspaceId { get; set; }
        /// <summary> The friendly name for the TAXII server. </summary>
        [WirePath("properties.friendlyName")]
        public string FriendlyName { get; set; }
        /// <summary> The API root for the TAXII server. </summary>
        [WirePath("properties.taxiiServer")]
        public string TaxiiServer { get; set; }
        /// <summary> The collection id of the TAXII server. </summary>
        [WirePath("properties.collectionId")]
        public string CollectionId { get; set; }
        /// <summary> The userName for the TAXII server. </summary>
        [WirePath("properties.userName")]
        public string UserName { get; set; }
        /// <summary> The password for the TAXII server. </summary>
        [WirePath("properties.password")]
        public string Password { get; set; }
        /// <summary> The lookback period for the TAXII server. </summary>
        [WirePath("properties.taxiiLookbackPeriod")]
        public DateTimeOffset? TaxiiLookbackPeriod { get; set; }
        /// <summary> The polling frequency for the TAXII server. </summary>
        [WirePath("properties.pollingFrequency")]
        public PollingFrequency? PollingFrequency { get; set; }
        /// <summary> Data type for TAXII connector. </summary>
        internal DataConnectorDataTypeCommon TaxiiClient { get; set; }
        /// <summary> Describe whether this data type connection is enabled or not. </summary>
        [WirePath("properties.taxiiClient.state")]
        public SecurityInsightsDataTypeConnectionState? TaxiiClientState
        {
            get => TaxiiClient is null ? default(SecurityInsightsDataTypeConnectionState?) : TaxiiClient.State;
            set
            {
                TaxiiClient = value.HasValue ? new DataConnectorDataTypeCommon(value.Value) : null;
            }
        }
    }
}
