// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The kind of the threat intelligence entity. </summary>
    internal readonly partial struct ThreatIntelligenceResourceInnerKind : IEquatable<ThreatIntelligenceResourceInnerKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceResourceInnerKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ThreatIntelligenceResourceInnerKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IndicatorValue = "indicator";

        /// <summary> Entity represents threat intelligence indicator in the system. </summary>
        public static ThreatIntelligenceResourceInnerKind Indicator { get; } = new ThreatIntelligenceResourceInnerKind(IndicatorValue);
        /// <summary> Determines if two <see cref="ThreatIntelligenceResourceInnerKind"/> values are the same. </summary>
        public static bool operator ==(ThreatIntelligenceResourceInnerKind left, ThreatIntelligenceResourceInnerKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ThreatIntelligenceResourceInnerKind"/> values are not the same. </summary>
        public static bool operator !=(ThreatIntelligenceResourceInnerKind left, ThreatIntelligenceResourceInnerKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ThreatIntelligenceResourceInnerKind"/>. </summary>
        public static implicit operator ThreatIntelligenceResourceInnerKind(string value) => new ThreatIntelligenceResourceInnerKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ThreatIntelligenceResourceInnerKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ThreatIntelligenceResourceInnerKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
