// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The direction to sort the results by. </summary>
    public readonly partial struct ThreatIntelligenceQuerySortingDirection : IEquatable<ThreatIntelligenceQuerySortingDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceQuerySortingDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ThreatIntelligenceQuerySortingDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ASCValue = "ASC";
        private const string DescValue = "DESC";

        /// <summary> Indicates that the query should be sorted from lowest-to-highest value. </summary>
        public static ThreatIntelligenceQuerySortingDirection ASC { get; } = new ThreatIntelligenceQuerySortingDirection(ASCValue);
        /// <summary> Indicates that the query should be sorted from lowest-to-highest value. </summary>
        public static ThreatIntelligenceQuerySortingDirection Desc { get; } = new ThreatIntelligenceQuerySortingDirection(DescValue);
        /// <summary> Determines if two <see cref="ThreatIntelligenceQuerySortingDirection"/> values are the same. </summary>
        public static bool operator ==(ThreatIntelligenceQuerySortingDirection left, ThreatIntelligenceQuerySortingDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ThreatIntelligenceQuerySortingDirection"/> values are not the same. </summary>
        public static bool operator !=(ThreatIntelligenceQuerySortingDirection left, ThreatIntelligenceQuerySortingDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ThreatIntelligenceQuerySortingDirection"/>. </summary>
        public static implicit operator ThreatIntelligenceQuerySortingDirection(string value) => new ThreatIntelligenceQuerySortingDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ThreatIntelligenceQuerySortingDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ThreatIntelligenceQuerySortingDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
