// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents boolean connectives used to join clauses in conditions. </summary>
    public readonly partial struct ThreatIntelligenceQueryConnective : IEquatable<ThreatIntelligenceQueryConnective>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceQueryConnective"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ThreatIntelligenceQueryConnective(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AndValue = "And";
        private const string OrValue = "Or";

        /// <summary> 'And' connective. </summary>
        public static ThreatIntelligenceQueryConnective And { get; } = new ThreatIntelligenceQueryConnective(AndValue);
        /// <summary> 'Or' connective. </summary>
        public static ThreatIntelligenceQueryConnective Or { get; } = new ThreatIntelligenceQueryConnective(OrValue);
        /// <summary> Determines if two <see cref="ThreatIntelligenceQueryConnective"/> values are the same. </summary>
        public static bool operator ==(ThreatIntelligenceQueryConnective left, ThreatIntelligenceQueryConnective right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ThreatIntelligenceQueryConnective"/> values are not the same. </summary>
        public static bool operator !=(ThreatIntelligenceQueryConnective left, ThreatIntelligenceQueryConnective right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ThreatIntelligenceQueryConnective"/>. </summary>
        public static implicit operator ThreatIntelligenceQueryConnective(string value) => new ThreatIntelligenceQueryConnective(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ThreatIntelligenceQueryConnective other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ThreatIntelligenceQueryConnective other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
