// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes parsed pattern entity. </summary>
    public partial class ThreatIntelligenceParsedPattern
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceParsedPattern"/>. </summary>
        public ThreatIntelligenceParsedPattern()
        {
            PatternTypeValues = new ChangeTrackingList<ThreatIntelligenceParsedPatternTypeValue>();
        }

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceParsedPattern"/>. </summary>
        /// <param name="patternTypeKey"> Pattern type key. </param>
        /// <param name="patternTypeValues"> Pattern type keys. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ThreatIntelligenceParsedPattern(string patternTypeKey, IList<ThreatIntelligenceParsedPatternTypeValue> patternTypeValues, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PatternTypeKey = patternTypeKey;
            PatternTypeValues = patternTypeValues;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Pattern type key. </summary>
        [WirePath("patternTypeKey")]
        public string PatternTypeKey { get; set; }
        /// <summary> Pattern type keys. </summary>
        [WirePath("patternTypeValues")]
        public IList<ThreatIntelligenceParsedPatternTypeValue> PatternTypeValues { get; }
    }
}
