// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes threat granular marking model entity. </summary>
    public partial class ThreatIntelligenceGranularMarkingEntity
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceGranularMarkingEntity"/>. </summary>
        public ThreatIntelligenceGranularMarkingEntity()
        {
            Selectors = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceGranularMarkingEntity"/>. </summary>
        /// <param name="language"> Language granular marking model. </param>
        /// <param name="markingRef"> marking reference granular marking model. </param>
        /// <param name="selectors"> granular marking model selectors. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ThreatIntelligenceGranularMarkingEntity(string language, int? markingRef, IList<string> selectors, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Language = language;
            MarkingRef = markingRef;
            Selectors = selectors;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Language granular marking model. </summary>
        [WirePath("language")]
        public string Language { get; set; }
        /// <summary> marking reference granular marking model. </summary>
        [WirePath("markingRef")]
        public int? MarkingRef { get; set; }
        /// <summary> granular marking model selectors. </summary>
        [WirePath("selectors")]
        public IList<string> Selectors { get; }
    }
}
