// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class ThreatIntelligenceFilteringCriteria : IUtf8JsonSerializable, IJsonModel<ThreatIntelligenceFilteringCriteria>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<ThreatIntelligenceFilteringCriteria>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<ThreatIntelligenceFilteringCriteria>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ThreatIntelligenceFilteringCriteria>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ThreatIntelligenceFilteringCriteria)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(PageSize))
            {
                writer.WritePropertyName("pageSize"u8);
                writer.WriteNumberValue(PageSize.Value);
            }
            if (Optional.IsDefined(MinConfidence))
            {
                writer.WritePropertyName("minConfidence"u8);
                writer.WriteNumberValue(MinConfidence.Value);
            }
            if (Optional.IsDefined(MaxConfidence))
            {
                writer.WritePropertyName("maxConfidence"u8);
                writer.WriteNumberValue(MaxConfidence.Value);
            }
            if (Optional.IsDefined(MinValidUntil))
            {
                writer.WritePropertyName("minValidUntil"u8);
                writer.WriteStringValue(MinValidUntil.Value, "O");
            }
            if (Optional.IsDefined(MaxValidUntil))
            {
                writer.WritePropertyName("maxValidUntil"u8);
                writer.WriteStringValue(MaxValidUntil.Value, "O");
            }
            if (Optional.IsDefined(IsIncludeDisabled))
            {
                writer.WritePropertyName("includeDisabled"u8);
                writer.WriteBooleanValue(IsIncludeDisabled.Value);
            }
            if (Optional.IsCollectionDefined(SortBy))
            {
                writer.WritePropertyName("sortBy"u8);
                writer.WriteStartArray();
                foreach (var item in SortBy)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Sources))
            {
                writer.WritePropertyName("sources"u8);
                writer.WriteStartArray();
                foreach (var item in Sources)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(PatternTypes))
            {
                writer.WritePropertyName("patternTypes"u8);
                writer.WriteStartArray();
                foreach (var item in PatternTypes)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ThreatTypes))
            {
                writer.WritePropertyName("threatTypes"u8);
                writer.WriteStartArray();
                foreach (var item in ThreatTypes)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Ids))
            {
                writer.WritePropertyName("ids"u8);
                writer.WriteStartArray();
                foreach (var item in Ids)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Keywords))
            {
                writer.WritePropertyName("keywords"u8);
                writer.WriteStartArray();
                foreach (var item in Keywords)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(SkipToken))
            {
                writer.WritePropertyName("skipToken"u8);
                writer.WriteStringValue(SkipToken);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        ThreatIntelligenceFilteringCriteria IJsonModel<ThreatIntelligenceFilteringCriteria>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ThreatIntelligenceFilteringCriteria>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(ThreatIntelligenceFilteringCriteria)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeThreatIntelligenceFilteringCriteria(document.RootElement, options);
        }

        internal static ThreatIntelligenceFilteringCriteria DeserializeThreatIntelligenceFilteringCriteria(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            int? pageSize = default;
            int? minConfidence = default;
            int? maxConfidence = default;
            DateTimeOffset? minValidUntil = default;
            DateTimeOffset? maxValidUntil = default;
            bool? includeDisabled = default;
            IList<ThreatIntelligenceSortingCriteria> sortBy = default;
            IList<string> sources = default;
            IList<string> patternTypes = default;
            IList<string> threatTypes = default;
            IList<string> ids = default;
            IList<string> keywords = default;
            string skipToken = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("pageSize"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pageSize = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minConfidence"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minConfidence = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("maxConfidence"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxConfidence = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("minValidUntil"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minValidUntil = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("maxValidUntil"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    maxValidUntil = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("includeDisabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    includeDisabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("sortBy"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<ThreatIntelligenceSortingCriteria> array = new List<ThreatIntelligenceSortingCriteria>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ThreatIntelligenceSortingCriteria.DeserializeThreatIntelligenceSortingCriteria(item, options));
                    }
                    sortBy = array;
                    continue;
                }
                if (property.NameEquals("sources"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    sources = array;
                    continue;
                }
                if (property.NameEquals("patternTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    patternTypes = array;
                    continue;
                }
                if (property.NameEquals("threatTypes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    threatTypes = array;
                    continue;
                }
                if (property.NameEquals("ids"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    ids = array;
                    continue;
                }
                if (property.NameEquals("keywords"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    keywords = array;
                    continue;
                }
                if (property.NameEquals("skipToken"u8))
                {
                    skipToken = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new ThreatIntelligenceFilteringCriteria(
                pageSize,
                minConfidence,
                maxConfidence,
                minValidUntil,
                maxValidUntil,
                includeDisabled,
                sortBy ?? new ChangeTrackingList<ThreatIntelligenceSortingCriteria>(),
                sources ?? new ChangeTrackingList<string>(),
                patternTypes ?? new ChangeTrackingList<string>(),
                threatTypes ?? new ChangeTrackingList<string>(),
                ids ?? new ChangeTrackingList<string>(),
                keywords ?? new ChangeTrackingList<string>(),
                skipToken,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<ThreatIntelligenceFilteringCriteria>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ThreatIntelligenceFilteringCriteria>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(ThreatIntelligenceFilteringCriteria)} does not support writing '{options.Format}' format.");
            }
        }

        ThreatIntelligenceFilteringCriteria IPersistableModel<ThreatIntelligenceFilteringCriteria>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<ThreatIntelligenceFilteringCriteria>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeThreatIntelligenceFilteringCriteria(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(ThreatIntelligenceFilteringCriteria)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<ThreatIntelligenceFilteringCriteria>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
