// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes external reference. </summary>
    public partial class ThreatIntelligenceExternalReference
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceExternalReference"/>. </summary>
        public ThreatIntelligenceExternalReference()
        {
            Hashes = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceExternalReference"/>. </summary>
        /// <param name="description"> External reference description. </param>
        /// <param name="externalId"> External reference ID. </param>
        /// <param name="sourceName"> External reference source name. </param>
        /// <param name="uri"> External reference URL. </param>
        /// <param name="hashes"> External reference hashes. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ThreatIntelligenceExternalReference(string description, string externalId, string sourceName, Uri uri, IDictionary<string, string> hashes, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Description = description;
            ExternalId = externalId;
            SourceName = sourceName;
            Uri = uri;
            Hashes = hashes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> External reference description. </summary>
        [WirePath("description")]
        public string Description { get; set; }
        /// <summary> External reference ID. </summary>
        [WirePath("externalId")]
        public string ExternalId { get; set; }
        /// <summary> External reference source name. </summary>
        [WirePath("sourceName")]
        public string SourceName { get; set; }
        /// <summary> External reference URL. </summary>
        [WirePath("url")]
        public Uri Uri { get; set; }
        /// <summary> External reference hashes. </summary>
        [WirePath("hashes")]
        public IDictionary<string, string> Hashes { get; }
    }
}
