// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Array of tags to be appended to the threat intelligence indicator. </summary>
    public partial class ThreatIntelligenceAppendTags
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceAppendTags"/>. </summary>
        public ThreatIntelligenceAppendTags()
        {
            ThreatIntelligenceTags = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ThreatIntelligenceAppendTags"/>. </summary>
        /// <param name="threatIntelligenceTags"> List of tags to be appended. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ThreatIntelligenceAppendTags(IList<string> threatIntelligenceTags, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ThreatIntelligenceTags = threatIntelligenceTags;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> List of tags to be appended. </summary>
        [WirePath("threatIntelligenceTags")]
        public IList<string> ThreatIntelligenceTags { get; }
    }
}
